<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentLabelData StructType
 * @subpackage Structs
 */
class ShipmentLabelData extends AbstractStructBase
{
    /**
     * The ParcelLabelData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData[]
     */
    public $ParcelLabelData;
    /**
     * Constructor method for ShipmentLabelData
     * @uses ShipmentLabelData::setParcelLabelData()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData[] $parcelLabelData
     */
    public function __construct(array $parcelLabelData = array())
    {
        $this
            ->setParcelLabelData($parcelLabelData);
    }
    /**
     * Get ParcelLabelData value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData[]|null
     */
    public function getParcelLabelData()
    {
        return $this->ParcelLabelData;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelLabelData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelLabelDataForArrayConstraintsFromSetParcelLabelData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentLabelDataParcelLabelDataItem) {
            // validation for constraint: itemType
            if (!$shipmentLabelDataParcelLabelDataItem instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData) {
                $invalidValues[] = is_object($shipmentLabelDataParcelLabelDataItem) ? get_class($shipmentLabelDataParcelLabelDataItem) : sprintf('%s(%s)', gettype($shipmentLabelDataParcelLabelDataItem), var_export($shipmentLabelDataParcelLabelDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ParcelLabelData property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ParcelLabelData value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData[] $parcelLabelData
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ShipmentLabelData
     */
    public function setParcelLabelData(array $parcelLabelData = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelLabelDataArrayErrorMessage = self::validateParcelLabelDataForArrayConstraintsFromSetParcelLabelData($parcelLabelData))) {
            throw new \InvalidArgumentException($parcelLabelDataArrayErrorMessage, __LINE__);
        }
        $this->ParcelLabelData = $parcelLabelData;
        return $this;
    }
    /**
     * Add item to ParcelLabelData value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ShipmentLabelData
     */
    public function addToParcelLabelData(\app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData) {
            throw new \InvalidArgumentException(sprintf('The ParcelLabelData property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\ParcelLabelData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ParcelLabelData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ShipmentLabelData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
