<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - base: xs:decimal
     * - minOccurs: 0
     * @var float
     */
    public $Weight;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Length;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * The PurposeOfShipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PurposeOfShipment;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ExportLicenseNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportLicenseNumber;
    /**
     * The CertificateNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CertificateNumber;
    /**
     * The ContentDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetails
     */
    public $ContentDetails;
    /**
     * The ShippingCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShippingCost;
    /**
     * Constructor method for Parcel
     * @uses Parcel::setWeight()
     * @uses Parcel::setLength()
     * @uses Parcel::setHeight()
     * @uses Parcel::setWidth()
     * @uses Parcel::setPurposeOfShipment()
     * @uses Parcel::setInvoiceNumber()
     * @uses Parcel::setExportLicenseNumber()
     * @uses Parcel::setCertificateNumber()
     * @uses Parcel::setContentDetails()
     * @uses Parcel::setShippingCost()
     * @param float $weight
     * @param int $length
     * @param int $height
     * @param int $width
     * @param string $purposeOfShipment
     * @param string $invoiceNumber
     * @param string $exportLicenseNumber
     * @param string $certificateNumber
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetails $contentDetails
     * @param float $shippingCost
     */
    public function __construct($weight = null, $length = null, $height = null, $width = null, $purposeOfShipment = null, $invoiceNumber = null, $exportLicenseNumber = null, $certificateNumber = null, \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetails $contentDetails = null, $shippingCost = null)
    {
        $this
            ->setWeight($weight)
            ->setLength($length)
            ->setHeight($height)
            ->setWidth($width)
            ->setPurposeOfShipment($purposeOfShipment)
            ->setInvoiceNumber($invoiceNumber)
            ->setExportLicenseNumber($exportLicenseNumber)
            ->setCertificateNumber($certificateNumber)
            ->setContentDetails($contentDetails)
            ->setShippingCost($shippingCost);
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get PurposeOfShipment value
     * @return string|null
     */
    public function getPurposeOfShipment()
    {
        return $this->PurposeOfShipment;
    }
    /**
     * Set PurposeOfShipment value
     * @param string $purposeOfShipment
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setPurposeOfShipment($purposeOfShipment = null)
    {
        // validation for constraint: string
        if (!is_null($purposeOfShipment) && !is_string($purposeOfShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeOfShipment, true), gettype($purposeOfShipment)), __LINE__);
        }
        $this->PurposeOfShipment = $purposeOfShipment;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get ExportLicenseNumber value
     * @return string|null
     */
    public function getExportLicenseNumber()
    {
        return $this->ExportLicenseNumber;
    }
    /**
     * Set ExportLicenseNumber value
     * @param string $exportLicenseNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setExportLicenseNumber($exportLicenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($exportLicenseNumber) && !is_string($exportLicenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLicenseNumber, true), gettype($exportLicenseNumber)), __LINE__);
        }
        $this->ExportLicenseNumber = $exportLicenseNumber;
        return $this;
    }
    /**
     * Get CertificateNumber value
     * @return string|null
     */
    public function getCertificateNumber()
    {
        return $this->CertificateNumber;
    }
    /**
     * Set CertificateNumber value
     * @param string $certificateNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setCertificateNumber($certificateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($certificateNumber) && !is_string($certificateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificateNumber, true), gettype($certificateNumber)), __LINE__);
        }
        $this->CertificateNumber = $certificateNumber;
        return $this;
    }
    /**
     * Get ContentDetails value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetails|null
     */
    public function getContentDetails()
    {
        return $this->ContentDetails;
    }
    /**
     * Set ContentDetails value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetails $contentDetails
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setContentDetails(\app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetails $contentDetails = null)
    {
        $this->ContentDetails = $contentDetails;
        return $this;
    }
    /**
     * Get ShippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->ShippingCost;
    }
    /**
     * Set ShippingCost value
     * @param float $shippingCost
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->ShippingCost = $shippingCost;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Parcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
