<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Enhancement StructType
 * @subpackage Structs
 */
class Enhancement extends AbstractStructBase
{
    /**
     * The EnhancedCompensation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EnhancedCompensation;
    /**
     * The SaturdayDeliveryRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SaturdayDeliveryRequired;
    /**
     * Constructor method for Enhancement
     * @uses Enhancement::setEnhancedCompensation()
     * @uses Enhancement::setSaturdayDeliveryRequired()
     * @param string $enhancedCompensation
     * @param bool $saturdayDeliveryRequired
     */
    public function __construct($enhancedCompensation = null, $saturdayDeliveryRequired = null)
    {
        $this
            ->setEnhancedCompensation($enhancedCompensation)
            ->setSaturdayDeliveryRequired($saturdayDeliveryRequired);
    }
    /**
     * Get EnhancedCompensation value
     * @return string|null
     */
    public function getEnhancedCompensation()
    {
        return $this->EnhancedCompensation;
    }
    /**
     * Set EnhancedCompensation value
     * @param string $enhancedCompensation
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement
     */
    public function setEnhancedCompensation($enhancedCompensation = null)
    {
        // validation for constraint: string
        if (!is_null($enhancedCompensation) && !is_string($enhancedCompensation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enhancedCompensation, true), gettype($enhancedCompensation)), __LINE__);
        }
        $this->EnhancedCompensation = $enhancedCompensation;
        return $this;
    }
    /**
     * Get SaturdayDeliveryRequired value
     * @return bool|null
     */
    public function getSaturdayDeliveryRequired()
    {
        return $this->SaturdayDeliveryRequired;
    }
    /**
     * Set SaturdayDeliveryRequired value
     * @param bool $saturdayDeliveryRequired
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement
     */
    public function setSaturdayDeliveryRequired($saturdayDeliveryRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayDeliveryRequired) && !is_bool($saturdayDeliveryRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturdayDeliveryRequired, true), gettype($saturdayDeliveryRequired)), __LINE__);
        }
        $this->SaturdayDeliveryRequired = $saturdayDeliveryRequired;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
