<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentDetail StructType
 * @subpackage Structs
 */
class ContentDetail extends AbstractStructBase
{
    /**
     * The CountryOfManufacture
     * @var string
     */
    public $CountryOfManufacture;
    /**
     * The CountryOfOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfOrigin;
    /**
     * The ManufacturersName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturersName;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The UnitWeight
     * Meta informations extracted from the WSDL
     * - base: xs:decimal
     * @var float
     */
    public $UnitWeight;
    /**
     * The UnitQuantity
     * @var int
     */
    public $UnitQuantity;
    /**
     * The UnitValue
     * @var float
     */
    public $UnitValue;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The TariffCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TariffCode;
    /**
     * The TariffDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TariffDescription;
    /**
     * The ArticleReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArticleReference;
    /**
     * Constructor method for ContentDetail
     * @uses ContentDetail::setCountryOfManufacture()
     * @uses ContentDetail::setCountryOfOrigin()
     * @uses ContentDetail::setManufacturersName()
     * @uses ContentDetail::setDescription()
     * @uses ContentDetail::setUnitWeight()
     * @uses ContentDetail::setUnitQuantity()
     * @uses ContentDetail::setUnitValue()
     * @uses ContentDetail::setCurrency()
     * @uses ContentDetail::setTariffCode()
     * @uses ContentDetail::setTariffDescription()
     * @uses ContentDetail::setArticleReference()
     * @param string $countryOfManufacture
     * @param string $countryOfOrigin
     * @param string $manufacturersName
     * @param string $description
     * @param float $unitWeight
     * @param int $unitQuantity
     * @param float $unitValue
     * @param string $currency
     * @param string $tariffCode
     * @param string $tariffDescription
     * @param string $articleReference
     */
    public function __construct($countryOfManufacture = null, $countryOfOrigin = null, $manufacturersName = null, $description = null, $unitWeight = null, $unitQuantity = null, $unitValue = null, $currency = null, $tariffCode = null, $tariffDescription = null, $articleReference = null)
    {
        $this
            ->setCountryOfManufacture($countryOfManufacture)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setManufacturersName($manufacturersName)
            ->setDescription($description)
            ->setUnitWeight($unitWeight)
            ->setUnitQuantity($unitQuantity)
            ->setUnitValue($unitValue)
            ->setCurrency($currency)
            ->setTariffCode($tariffCode)
            ->setTariffDescription($tariffDescription)
            ->setArticleReference($articleReference);
    }
    /**
     * Get CountryOfManufacture value
     * @return string|null
     */
    public function getCountryOfManufacture()
    {
        return $this->CountryOfManufacture;
    }
    /**
     * Set CountryOfManufacture value
     * @param string $countryOfManufacture
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setCountryOfManufacture($countryOfManufacture = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfManufacture) && !is_string($countryOfManufacture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfManufacture, true), gettype($countryOfManufacture)), __LINE__);
        }
        $this->CountryOfManufacture = $countryOfManufacture;
        return $this;
    }
    /**
     * Get CountryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->CountryOfOrigin;
    }
    /**
     * Set CountryOfOrigin value
     * @param string $countryOfOrigin
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        $this->CountryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get ManufacturersName value
     * @return string|null
     */
    public function getManufacturersName()
    {
        return $this->ManufacturersName;
    }
    /**
     * Set ManufacturersName value
     * @param string $manufacturersName
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setManufacturersName($manufacturersName = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturersName) && !is_string($manufacturersName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturersName, true), gettype($manufacturersName)), __LINE__);
        }
        $this->ManufacturersName = $manufacturersName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UnitWeight value
     * @return float|null
     */
    public function getUnitWeight()
    {
        return $this->UnitWeight;
    }
    /**
     * Set UnitWeight value
     * @param float $unitWeight
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setUnitWeight($unitWeight = null)
    {
        // validation for constraint: float
        if (!is_null($unitWeight) && !(is_float($unitWeight) || is_numeric($unitWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitWeight, true), gettype($unitWeight)), __LINE__);
        }
        $this->UnitWeight = $unitWeight;
        return $this;
    }
    /**
     * Get UnitQuantity value
     * @return int|null
     */
    public function getUnitQuantity()
    {
        return $this->UnitQuantity;
    }
    /**
     * Set UnitQuantity value
     * @param int $unitQuantity
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setUnitQuantity($unitQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($unitQuantity) && !(is_int($unitQuantity) || ctype_digit($unitQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitQuantity, true), gettype($unitQuantity)), __LINE__);
        }
        $this->UnitQuantity = $unitQuantity;
        return $this;
    }
    /**
     * Get UnitValue value
     * @return float|null
     */
    public function getUnitValue()
    {
        return $this->UnitValue;
    }
    /**
     * Set UnitValue value
     * @param float $unitValue
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setUnitValue($unitValue = null)
    {
        // validation for constraint: float
        if (!is_null($unitValue) && !(is_float($unitValue) || is_numeric($unitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitValue, true), gettype($unitValue)), __LINE__);
        }
        $this->UnitValue = $unitValue;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get TariffCode value
     * @return string|null
     */
    public function getTariffCode()
    {
        return $this->TariffCode;
    }
    /**
     * Set TariffCode value
     * @param string $tariffCode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setTariffCode($tariffCode = null)
    {
        // validation for constraint: string
        if (!is_null($tariffCode) && !is_string($tariffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffCode, true), gettype($tariffCode)), __LINE__);
        }
        $this->TariffCode = $tariffCode;
        return $this;
    }
    /**
     * Get TariffDescription value
     * @return string|null
     */
    public function getTariffDescription()
    {
        return $this->TariffDescription;
    }
    /**
     * Set TariffDescription value
     * @param string $tariffDescription
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setTariffDescription($tariffDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tariffDescription) && !is_string($tariffDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffDescription, true), gettype($tariffDescription)), __LINE__);
        }
        $this->TariffDescription = $tariffDescription;
        return $this;
    }
    /**
     * Get ArticleReference value
     * @return string|null
     */
    public function getArticleReference()
    {
        return $this->ArticleReference;
    }
    /**
     * Set ArticleReference value
     * @param string $articleReference
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public function setArticleReference($articleReference = null)
    {
        // validation for constraint: string
        if (!is_null($articleReference) && !is_string($articleReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleReference, true), gettype($articleReference)), __LINE__);
        }
        $this->ArticleReference = $articleReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ContentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
