<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updatePackageInfo StructType
 * Meta informations extracted from the WSDL
 * - type: tns:updatePackageInfo
 * @subpackage Structs
 */
class UpdatePackageInfo extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The packageNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageNo;
    /**
     * The transporterName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transporterName;
    /**
     * The packtrackURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packtrackURL;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The sentid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sentid;
    /**
     * Constructor method for updatePackageInfo
     * @uses UpdatePackageInfo::setLogin()
     * @uses UpdatePackageInfo::setPassword()
     * @uses UpdatePackageInfo::setPackageNo()
     * @uses UpdatePackageInfo::setTransporterName()
     * @uses UpdatePackageInfo::setPacktrackURL()
     * @uses UpdatePackageInfo::setMessage()
     * @uses UpdatePackageInfo::setSentid()
     * @param int $login
     * @param string $password
     * @param string $packageNo
     * @param string $transporterName
     * @param string $packtrackURL
     * @param string $message
     * @param int $sentid
     */
    public function __construct($login = null, $password = null, $packageNo = null, $transporterName = null, $packtrackURL = null, $message = null, $sentid = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setPackageNo($packageNo)
            ->setTransporterName($transporterName)
            ->setPacktrackURL($packtrackURL)
            ->setMessage($message)
            ->setSentid($sentid);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\UpdatePackageInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\UpdatePackageInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get packageNo value
     * @return string|null
     */
    public function getPackageNo()
    {
        return $this->packageNo;
    }
    /**
     * Set packageNo value
     * @param string $packageNo
     * @return \StructType\UpdatePackageInfo
     */
    public function setPackageNo($packageNo = null)
    {
        // validation for constraint: string
        if (!is_null($packageNo) && !is_string($packageNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageNo, true), gettype($packageNo)), __LINE__);
        }
        $this->packageNo = $packageNo;
        return $this;
    }
    /**
     * Get transporterName value
     * @return string|null
     */
    public function getTransporterName()
    {
        return $this->transporterName;
    }
    /**
     * Set transporterName value
     * @param string $transporterName
     * @return \StructType\UpdatePackageInfo
     */
    public function setTransporterName($transporterName = null)
    {
        // validation for constraint: string
        if (!is_null($transporterName) && !is_string($transporterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transporterName, true), gettype($transporterName)), __LINE__);
        }
        $this->transporterName = $transporterName;
        return $this;
    }
    /**
     * Get packtrackURL value
     * @return string|null
     */
    public function getPacktrackURL()
    {
        return $this->packtrackURL;
    }
    /**
     * Set packtrackURL value
     * @param string $packtrackURL
     * @return \StructType\UpdatePackageInfo
     */
    public function setPacktrackURL($packtrackURL = null)
    {
        // validation for constraint: string
        if (!is_null($packtrackURL) && !is_string($packtrackURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packtrackURL, true), gettype($packtrackURL)), __LINE__);
        }
        $this->packtrackURL = $packtrackURL;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\UpdatePackageInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get sentid value
     * @return int|null
     */
    public function getSentid()
    {
        return $this->sentid;
    }
    /**
     * Set sentid value
     * @param int $sentid
     * @return \StructType\UpdatePackageInfo
     */
    public function setSentid($sentid = null)
    {
        // validation for constraint: int
        if (!is_null($sentid) && !(is_int($sentid) || ctype_digit($sentid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sentid, true), gettype($sentid)), __LINE__);
        }
        $this->sentid = $sentid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdatePackageInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
