<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateOrderResponse StructType
 * @subpackage Structs
 */
class UpdateOrderResponse extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The authorzationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authorzationId;
    /**
     * The extraCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $extraCost;
    /**
     * The freightCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $freightCost;
    /**
     * The insertUpdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsertUpdateResponse
     */
    public $insertUpdate;
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethod;
    /**
     * Constructor method for updateOrderResponse
     * @uses UpdateOrderResponse::setAmount()
     * @uses UpdateOrderResponse::setAuthorzationId()
     * @uses UpdateOrderResponse::setExtraCost()
     * @uses UpdateOrderResponse::setFreightCost()
     * @uses UpdateOrderResponse::setInsertUpdate()
     * @uses UpdateOrderResponse::setPaymentMethod()
     * @param float $amount
     * @param string $authorzationId
     * @param float $extraCost
     * @param float $freightCost
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @param string $paymentMethod
     */
    public function __construct($amount = null, $authorzationId = null, $extraCost = null, $freightCost = null, \StructType\InsertUpdateResponse $insertUpdate = null, $paymentMethod = null)
    {
        $this
            ->setAmount($amount)
            ->setAuthorzationId($authorzationId)
            ->setExtraCost($extraCost)
            ->setFreightCost($freightCost)
            ->setInsertUpdate($insertUpdate)
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\UpdateOrderResponse
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get authorzationId value
     * @return string|null
     */
    public function getAuthorzationId()
    {
        return $this->authorzationId;
    }
    /**
     * Set authorzationId value
     * @param string $authorzationId
     * @return \StructType\UpdateOrderResponse
     */
    public function setAuthorzationId($authorzationId = null)
    {
        // validation for constraint: string
        if (!is_null($authorzationId) && !is_string($authorzationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorzationId, true), gettype($authorzationId)), __LINE__);
        }
        $this->authorzationId = $authorzationId;
        return $this;
    }
    /**
     * Get extraCost value
     * @return float|null
     */
    public function getExtraCost()
    {
        return $this->extraCost;
    }
    /**
     * Set extraCost value
     * @param float $extraCost
     * @return \StructType\UpdateOrderResponse
     */
    public function setExtraCost($extraCost = null)
    {
        // validation for constraint: float
        if (!is_null($extraCost) && !(is_float($extraCost) || is_numeric($extraCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extraCost, true), gettype($extraCost)), __LINE__);
        }
        $this->extraCost = $extraCost;
        return $this;
    }
    /**
     * Get freightCost value
     * @return float|null
     */
    public function getFreightCost()
    {
        return $this->freightCost;
    }
    /**
     * Set freightCost value
     * @param float $freightCost
     * @return \StructType\UpdateOrderResponse
     */
    public function setFreightCost($freightCost = null)
    {
        // validation for constraint: float
        if (!is_null($freightCost) && !(is_float($freightCost) || is_numeric($freightCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightCost, true), gettype($freightCost)), __LINE__);
        }
        $this->freightCost = $freightCost;
        return $this;
    }
    /**
     * Get insertUpdate value
     * @return \StructType\InsertUpdateResponse|null
     */
    public function getInsertUpdate()
    {
        return $this->insertUpdate;
    }
    /**
     * Set insertUpdate value
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @return \StructType\UpdateOrderResponse
     */
    public function setInsertUpdate(\StructType\InsertUpdateResponse $insertUpdate = null)
    {
        $this->insertUpdate = $insertUpdate;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \StructType\UpdateOrderResponse
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateOrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
