<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The creditApplicants
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $creditApplicants;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The onlineCustomers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $onlineCustomers;
    /**
     * The operationResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationResult;
    /**
     * The orders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orders;
    /**
     * Constructor method for status
     * @uses Status::setCreditApplicants()
     * @uses Status::setMessage()
     * @uses Status::setOnlineCustomers()
     * @uses Status::setOperationResult()
     * @uses Status::setOrders()
     * @param int $creditApplicants
     * @param string $message
     * @param int $onlineCustomers
     * @param int $operationResult
     * @param int $orders
     */
    public function __construct($creditApplicants = null, $message = null, $onlineCustomers = null, $operationResult = null, $orders = null)
    {
        $this
            ->setCreditApplicants($creditApplicants)
            ->setMessage($message)
            ->setOnlineCustomers($onlineCustomers)
            ->setOperationResult($operationResult)
            ->setOrders($orders);
    }
    /**
     * Get creditApplicants value
     * @return int|null
     */
    public function getCreditApplicants()
    {
        return $this->creditApplicants;
    }
    /**
     * Set creditApplicants value
     * @param int $creditApplicants
     * @return \StructType\Status
     */
    public function setCreditApplicants($creditApplicants = null)
    {
        // validation for constraint: int
        if (!is_null($creditApplicants) && !(is_int($creditApplicants) || ctype_digit($creditApplicants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditApplicants, true), gettype($creditApplicants)), __LINE__);
        }
        $this->creditApplicants = $creditApplicants;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Status
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get onlineCustomers value
     * @return int|null
     */
    public function getOnlineCustomers()
    {
        return $this->onlineCustomers;
    }
    /**
     * Set onlineCustomers value
     * @param int $onlineCustomers
     * @return \StructType\Status
     */
    public function setOnlineCustomers($onlineCustomers = null)
    {
        // validation for constraint: int
        if (!is_null($onlineCustomers) && !(is_int($onlineCustomers) || ctype_digit($onlineCustomers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineCustomers, true), gettype($onlineCustomers)), __LINE__);
        }
        $this->onlineCustomers = $onlineCustomers;
        return $this;
    }
    /**
     * Get operationResult value
     * @return int|null
     */
    public function getOperationResult()
    {
        return $this->operationResult;
    }
    /**
     * Set operationResult value
     * @param int $operationResult
     * @return \StructType\Status
     */
    public function setOperationResult($operationResult = null)
    {
        // validation for constraint: int
        if (!is_null($operationResult) && !(is_int($operationResult) || ctype_digit($operationResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationResult, true), gettype($operationResult)), __LINE__);
        }
        $this->operationResult = $operationResult;
        return $this;
    }
    /**
     * Get orders value
     * @return int|null
     */
    public function getOrders()
    {
        return $this->orders;
    }
    /**
     * Set orders value
     * @param int $orders
     * @return \StructType\Status
     */
    public function setOrders($orders = null)
    {
        // validation for constraint: int
        if (!is_null($orders) && !(is_int($orders) || ctype_digit($orders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orders, true), gettype($orders)), __LINE__);
        }
        $this->orders = $orders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
