<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendDiscount StructType
 * Meta informations extracted from the WSDL
 * - type: tns:sendDiscount
 * @subpackage Structs
 */
class SendDiscount extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Discount
     */
    public $discount;
    /**
     * Constructor method for sendDiscount
     * @uses SendDiscount::setLogin()
     * @uses SendDiscount::setPassword()
     * @uses SendDiscount::setDiscount()
     * @param int $login
     * @param string $password
     * @param \StructType\Discount $discount
     */
    public function __construct($login = null, $password = null, \StructType\Discount $discount = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setDiscount($discount);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendDiscount
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendDiscount
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get discount value
     * @return \StructType\Discount|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param \StructType\Discount $discount
     * @return \StructType\SendDiscount
     */
    public function setDiscount(\StructType\Discount $discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendDiscount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
