<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The alternativeTax
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $alternativeTax;
    /**
     * The contactAddressline1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contactAddressline1;
    /**
     * The contactAddressline2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contactAddressline2;
    /**
     * The contactId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $contactId;
    /**
     * The contactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contactName;
    /**
     * The contactPostCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contactPostCity;
    /**
     * The contactPostNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contactPostNo;
    /**
     * The deliveredItemsAndCapturedPaymentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveredItemsAndCapturedPaymentInfo
     */
    public $deliveredItemsAndCapturedPaymentInfo;
    /**
     * The deliveryAddressLine1
     * @var string
     */
    public $deliveryAddressLine1;
    /**
     * The deliveryAddressLine2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deliveryAddressLine2;
    /**
     * The deliveryName
     * @var string
     */
    public $deliveryName;
    /**
     * The deliveryPostCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deliveryPostCity;
    /**
     * The deliveryPostNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deliveryPostNo;
    /**
     * The deltaOrderId
     * @var int
     */
    public $deltaOrderId;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The extraCost
     * @var float
     */
    public $extraCost;
    /**
     * The extraCostDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $extraCostDescription;
    /**
     * The freightCost
     * @var float
     */
    public $freightCost;
    /**
     * The freightCostDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $freightCostDescription;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The orderLines
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderLine[]
     */
    public $orderLines;
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentMethod;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The storePickup
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $storePickup;
    /**
     * The taxExempt
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $taxExempt;
    /**
     * The wantedDeliveryTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $wantedDeliveryTime;
    /**
     * Constructor method for order
     * @uses Order::setAlternativeTax()
     * @uses Order::setContactAddressline1()
     * @uses Order::setContactAddressline2()
     * @uses Order::setContactId()
     * @uses Order::setContactName()
     * @uses Order::setContactPostCity()
     * @uses Order::setContactPostNo()
     * @uses Order::setDeliveredItemsAndCapturedPaymentInfo()
     * @uses Order::setDeliveryAddressLine1()
     * @uses Order::setDeliveryAddressLine2()
     * @uses Order::setDeliveryName()
     * @uses Order::setDeliveryPostCity()
     * @uses Order::setDeliveryPostNo()
     * @uses Order::setDeltaOrderId()
     * @uses Order::setEmail()
     * @uses Order::setExtraCost()
     * @uses Order::setExtraCostDescription()
     * @uses Order::setFreightCost()
     * @uses Order::setFreightCostDescription()
     * @uses Order::setMessage()
     * @uses Order::setOrderLines()
     * @uses Order::setPaymentMethod()
     * @uses Order::setPhone()
     * @uses Order::setStorePickup()
     * @uses Order::setTaxExempt()
     * @uses Order::setWantedDeliveryTime()
     * @param bool $alternativeTax
     * @param string $contactAddressline1
     * @param string $contactAddressline2
     * @param int $contactId
     * @param string $contactName
     * @param string $contactPostCity
     * @param string $contactPostNo
     * @param \StructType\DeliveredItemsAndCapturedPaymentInfo $deliveredItemsAndCapturedPaymentInfo
     * @param string $deliveryAddressLine1
     * @param string $deliveryAddressLine2
     * @param string $deliveryName
     * @param string $deliveryPostCity
     * @param string $deliveryPostNo
     * @param int $deltaOrderId
     * @param string $email
     * @param float $extraCost
     * @param string $extraCostDescription
     * @param float $freightCost
     * @param string $freightCostDescription
     * @param string $message
     * @param \StructType\OrderLine[] $orderLines
     * @param int $paymentMethod
     * @param string $phone
     * @param bool $storePickup
     * @param bool $taxExempt
     * @param string $wantedDeliveryTime
     */
    public function __construct($alternativeTax = null, $contactAddressline1 = null, $contactAddressline2 = null, $contactId = null, $contactName = null, $contactPostCity = null, $contactPostNo = null, \StructType\DeliveredItemsAndCapturedPaymentInfo $deliveredItemsAndCapturedPaymentInfo = null, $deliveryAddressLine1 = null, $deliveryAddressLine2 = null, $deliveryName = null, $deliveryPostCity = null, $deliveryPostNo = null, $deltaOrderId = null, $email = null, $extraCost = null, $extraCostDescription = null, $freightCost = null, $freightCostDescription = null, $message = null, array $orderLines = array(), $paymentMethod = null, $phone = null, $storePickup = null, $taxExempt = null, $wantedDeliveryTime = null)
    {
        $this
            ->setAlternativeTax($alternativeTax)
            ->setContactAddressline1($contactAddressline1)
            ->setContactAddressline2($contactAddressline2)
            ->setContactId($contactId)
            ->setContactName($contactName)
            ->setContactPostCity($contactPostCity)
            ->setContactPostNo($contactPostNo)
            ->setDeliveredItemsAndCapturedPaymentInfo($deliveredItemsAndCapturedPaymentInfo)
            ->setDeliveryAddressLine1($deliveryAddressLine1)
            ->setDeliveryAddressLine2($deliveryAddressLine2)
            ->setDeliveryName($deliveryName)
            ->setDeliveryPostCity($deliveryPostCity)
            ->setDeliveryPostNo($deliveryPostNo)
            ->setDeltaOrderId($deltaOrderId)
            ->setEmail($email)
            ->setExtraCost($extraCost)
            ->setExtraCostDescription($extraCostDescription)
            ->setFreightCost($freightCost)
            ->setFreightCostDescription($freightCostDescription)
            ->setMessage($message)
            ->setOrderLines($orderLines)
            ->setPaymentMethod($paymentMethod)
            ->setPhone($phone)
            ->setStorePickup($storePickup)
            ->setTaxExempt($taxExempt)
            ->setWantedDeliveryTime($wantedDeliveryTime);
    }
    /**
     * Get alternativeTax value
     * @return bool|null
     */
    public function getAlternativeTax()
    {
        return $this->alternativeTax;
    }
    /**
     * Set alternativeTax value
     * @param bool $alternativeTax
     * @return \StructType\Order
     */
    public function setAlternativeTax($alternativeTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($alternativeTax) && !is_bool($alternativeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alternativeTax, true), gettype($alternativeTax)), __LINE__);
        }
        $this->alternativeTax = $alternativeTax;
        return $this;
    }
    /**
     * Get contactAddressline1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactAddressline1()
    {
        return isset($this->contactAddressline1) ? $this->contactAddressline1 : null;
    }
    /**
     * Set contactAddressline1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactAddressline1
     * @return \StructType\Order
     */
    public function setContactAddressline1($contactAddressline1 = null)
    {
        // validation for constraint: string
        if (!is_null($contactAddressline1) && !is_string($contactAddressline1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactAddressline1, true), gettype($contactAddressline1)), __LINE__);
        }
        if (is_null($contactAddressline1) || (is_array($contactAddressline1) && empty($contactAddressline1))) {
            unset($this->contactAddressline1);
        } else {
            $this->contactAddressline1 = $contactAddressline1;
        }
        return $this;
    }
    /**
     * Get contactAddressline2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactAddressline2()
    {
        return isset($this->contactAddressline2) ? $this->contactAddressline2 : null;
    }
    /**
     * Set contactAddressline2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactAddressline2
     * @return \StructType\Order
     */
    public function setContactAddressline2($contactAddressline2 = null)
    {
        // validation for constraint: string
        if (!is_null($contactAddressline2) && !is_string($contactAddressline2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactAddressline2, true), gettype($contactAddressline2)), __LINE__);
        }
        if (is_null($contactAddressline2) || (is_array($contactAddressline2) && empty($contactAddressline2))) {
            unset($this->contactAddressline2);
        } else {
            $this->contactAddressline2 = $contactAddressline2;
        }
        return $this;
    }
    /**
     * Get contactId value
     * @return int|null
     */
    public function getContactId()
    {
        return $this->contactId;
    }
    /**
     * Set contactId value
     * @param int $contactId
     * @return \StructType\Order
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->contactId = $contactId;
        return $this;
    }
    /**
     * Get contactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactName()
    {
        return isset($this->contactName) ? $this->contactName : null;
    }
    /**
     * Set contactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactName
     * @return \StructType\Order
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        if (is_null($contactName) || (is_array($contactName) && empty($contactName))) {
            unset($this->contactName);
        } else {
            $this->contactName = $contactName;
        }
        return $this;
    }
    /**
     * Get contactPostCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPostCity()
    {
        return isset($this->contactPostCity) ? $this->contactPostCity : null;
    }
    /**
     * Set contactPostCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPostCity
     * @return \StructType\Order
     */
    public function setContactPostCity($contactPostCity = null)
    {
        // validation for constraint: string
        if (!is_null($contactPostCity) && !is_string($contactPostCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPostCity, true), gettype($contactPostCity)), __LINE__);
        }
        if (is_null($contactPostCity) || (is_array($contactPostCity) && empty($contactPostCity))) {
            unset($this->contactPostCity);
        } else {
            $this->contactPostCity = $contactPostCity;
        }
        return $this;
    }
    /**
     * Get contactPostNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPostNo()
    {
        return isset($this->contactPostNo) ? $this->contactPostNo : null;
    }
    /**
     * Set contactPostNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPostNo
     * @return \StructType\Order
     */
    public function setContactPostNo($contactPostNo = null)
    {
        // validation for constraint: string
        if (!is_null($contactPostNo) && !is_string($contactPostNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPostNo, true), gettype($contactPostNo)), __LINE__);
        }
        if (is_null($contactPostNo) || (is_array($contactPostNo) && empty($contactPostNo))) {
            unset($this->contactPostNo);
        } else {
            $this->contactPostNo = $contactPostNo;
        }
        return $this;
    }
    /**
     * Get deliveredItemsAndCapturedPaymentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveredItemsAndCapturedPaymentInfo|null
     */
    public function getDeliveredItemsAndCapturedPaymentInfo()
    {
        return isset($this->deliveredItemsAndCapturedPaymentInfo) ? $this->deliveredItemsAndCapturedPaymentInfo : null;
    }
    /**
     * Set deliveredItemsAndCapturedPaymentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeliveredItemsAndCapturedPaymentInfo $deliveredItemsAndCapturedPaymentInfo
     * @return \StructType\Order
     */
    public function setDeliveredItemsAndCapturedPaymentInfo(\StructType\DeliveredItemsAndCapturedPaymentInfo $deliveredItemsAndCapturedPaymentInfo = null)
    {
        if (is_null($deliveredItemsAndCapturedPaymentInfo) || (is_array($deliveredItemsAndCapturedPaymentInfo) && empty($deliveredItemsAndCapturedPaymentInfo))) {
            unset($this->deliveredItemsAndCapturedPaymentInfo);
        } else {
            $this->deliveredItemsAndCapturedPaymentInfo = $deliveredItemsAndCapturedPaymentInfo;
        }
        return $this;
    }
    /**
     * Get deliveryAddressLine1 value
     * @return string|null
     */
    public function getDeliveryAddressLine1()
    {
        return $this->deliveryAddressLine1;
    }
    /**
     * Set deliveryAddressLine1 value
     * @param string $deliveryAddressLine1
     * @return \StructType\Order
     */
    public function setDeliveryAddressLine1($deliveryAddressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddressLine1) && !is_string($deliveryAddressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddressLine1, true), gettype($deliveryAddressLine1)), __LINE__);
        }
        $this->deliveryAddressLine1 = $deliveryAddressLine1;
        return $this;
    }
    /**
     * Get deliveryAddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAddressLine2()
    {
        return isset($this->deliveryAddressLine2) ? $this->deliveryAddressLine2 : null;
    }
    /**
     * Set deliveryAddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAddressLine2
     * @return \StructType\Order
     */
    public function setDeliveryAddressLine2($deliveryAddressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddressLine2) && !is_string($deliveryAddressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddressLine2, true), gettype($deliveryAddressLine2)), __LINE__);
        }
        if (is_null($deliveryAddressLine2) || (is_array($deliveryAddressLine2) && empty($deliveryAddressLine2))) {
            unset($this->deliveryAddressLine2);
        } else {
            $this->deliveryAddressLine2 = $deliveryAddressLine2;
        }
        return $this;
    }
    /**
     * Get deliveryName value
     * @return string|null
     */
    public function getDeliveryName()
    {
        return $this->deliveryName;
    }
    /**
     * Set deliveryName value
     * @param string $deliveryName
     * @return \StructType\Order
     */
    public function setDeliveryName($deliveryName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryName) && !is_string($deliveryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryName, true), gettype($deliveryName)), __LINE__);
        }
        $this->deliveryName = $deliveryName;
        return $this;
    }
    /**
     * Get deliveryPostCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryPostCity()
    {
        return isset($this->deliveryPostCity) ? $this->deliveryPostCity : null;
    }
    /**
     * Set deliveryPostCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryPostCity
     * @return \StructType\Order
     */
    public function setDeliveryPostCity($deliveryPostCity = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPostCity) && !is_string($deliveryPostCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPostCity, true), gettype($deliveryPostCity)), __LINE__);
        }
        if (is_null($deliveryPostCity) || (is_array($deliveryPostCity) && empty($deliveryPostCity))) {
            unset($this->deliveryPostCity);
        } else {
            $this->deliveryPostCity = $deliveryPostCity;
        }
        return $this;
    }
    /**
     * Get deliveryPostNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryPostNo()
    {
        return isset($this->deliveryPostNo) ? $this->deliveryPostNo : null;
    }
    /**
     * Set deliveryPostNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryPostNo
     * @return \StructType\Order
     */
    public function setDeliveryPostNo($deliveryPostNo = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPostNo) && !is_string($deliveryPostNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPostNo, true), gettype($deliveryPostNo)), __LINE__);
        }
        if (is_null($deliveryPostNo) || (is_array($deliveryPostNo) && empty($deliveryPostNo))) {
            unset($this->deliveryPostNo);
        } else {
            $this->deliveryPostNo = $deliveryPostNo;
        }
        return $this;
    }
    /**
     * Get deltaOrderId value
     * @return int|null
     */
    public function getDeltaOrderId()
    {
        return $this->deltaOrderId;
    }
    /**
     * Set deltaOrderId value
     * @param int $deltaOrderId
     * @return \StructType\Order
     */
    public function setDeltaOrderId($deltaOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($deltaOrderId) && !(is_int($deltaOrderId) || ctype_digit($deltaOrderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deltaOrderId, true), gettype($deltaOrderId)), __LINE__);
        }
        $this->deltaOrderId = $deltaOrderId;
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\Order
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get extraCost value
     * @return float|null
     */
    public function getExtraCost()
    {
        return $this->extraCost;
    }
    /**
     * Set extraCost value
     * @param float $extraCost
     * @return \StructType\Order
     */
    public function setExtraCost($extraCost = null)
    {
        // validation for constraint: float
        if (!is_null($extraCost) && !(is_float($extraCost) || is_numeric($extraCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extraCost, true), gettype($extraCost)), __LINE__);
        }
        $this->extraCost = $extraCost;
        return $this;
    }
    /**
     * Get extraCostDescription value
     * @return string|null
     */
    public function getExtraCostDescription()
    {
        return $this->extraCostDescription;
    }
    /**
     * Set extraCostDescription value
     * @param string $extraCostDescription
     * @return \StructType\Order
     */
    public function setExtraCostDescription($extraCostDescription = null)
    {
        // validation for constraint: string
        if (!is_null($extraCostDescription) && !is_string($extraCostDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraCostDescription, true), gettype($extraCostDescription)), __LINE__);
        }
        $this->extraCostDescription = $extraCostDescription;
        return $this;
    }
    /**
     * Get freightCost value
     * @return float|null
     */
    public function getFreightCost()
    {
        return $this->freightCost;
    }
    /**
     * Set freightCost value
     * @param float $freightCost
     * @return \StructType\Order
     */
    public function setFreightCost($freightCost = null)
    {
        // validation for constraint: float
        if (!is_null($freightCost) && !(is_float($freightCost) || is_numeric($freightCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightCost, true), gettype($freightCost)), __LINE__);
        }
        $this->freightCost = $freightCost;
        return $this;
    }
    /**
     * Get freightCostDescription value
     * @return string|null
     */
    public function getFreightCostDescription()
    {
        return $this->freightCostDescription;
    }
    /**
     * Set freightCostDescription value
     * @param string $freightCostDescription
     * @return \StructType\Order
     */
    public function setFreightCostDescription($freightCostDescription = null)
    {
        // validation for constraint: string
        if (!is_null($freightCostDescription) && !is_string($freightCostDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freightCostDescription, true), gettype($freightCostDescription)), __LINE__);
        }
        $this->freightCostDescription = $freightCostDescription;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Order
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get orderLines value
     * @return \StructType\OrderLine[]|null
     */
    public function getOrderLines()
    {
        return $this->orderLines;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderLinesForArrayConstraintsFromSetOrderLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderOrderLinesItem) {
            // validation for constraint: itemType
            if (!$orderOrderLinesItem instanceof \StructType\OrderLine) {
                $invalidValues[] = is_object($orderOrderLinesItem) ? get_class($orderOrderLinesItem) : sprintf('%s(%s)', gettype($orderOrderLinesItem), var_export($orderOrderLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderLines property can only contain items of type \StructType\OrderLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderLines value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderLine[] $orderLines
     * @return \StructType\Order
     */
    public function setOrderLines(array $orderLines = array())
    {
        // validation for constraint: array
        if ('' !== ($orderLinesArrayErrorMessage = self::validateOrderLinesForArrayConstraintsFromSetOrderLines($orderLines))) {
            throw new \InvalidArgumentException($orderLinesArrayErrorMessage, __LINE__);
        }
        $this->orderLines = $orderLines;
        return $this;
    }
    /**
     * Add item to orderLines value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderLine $item
     * @return \StructType\Order
     */
    public function addToOrderLines(\StructType\OrderLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderLine) {
            throw new \InvalidArgumentException(sprintf('The orderLines property can only contain items of type \StructType\OrderLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderLines[] = $item;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return int|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param int $paymentMethod
     * @return \StructType\Order
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMethod) && !(is_int($paymentMethod) || ctype_digit($paymentMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Order
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get storePickup value
     * @return bool|null
     */
    public function getStorePickup()
    {
        return $this->storePickup;
    }
    /**
     * Set storePickup value
     * @param bool $storePickup
     * @return \StructType\Order
     */
    public function setStorePickup($storePickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($storePickup) && !is_bool($storePickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storePickup, true), gettype($storePickup)), __LINE__);
        }
        $this->storePickup = $storePickup;
        return $this;
    }
    /**
     * Get taxExempt value
     * @return bool|null
     */
    public function getTaxExempt()
    {
        return $this->taxExempt;
    }
    /**
     * Set taxExempt value
     * @param bool $taxExempt
     * @return \StructType\Order
     */
    public function setTaxExempt($taxExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExempt) && !is_bool($taxExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExempt, true), gettype($taxExempt)), __LINE__);
        }
        $this->taxExempt = $taxExempt;
        return $this;
    }
    /**
     * Get wantedDeliveryTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWantedDeliveryTime()
    {
        return isset($this->wantedDeliveryTime) ? $this->wantedDeliveryTime : null;
    }
    /**
     * Set wantedDeliveryTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wantedDeliveryTime
     * @return \StructType\Order
     */
    public function setWantedDeliveryTime($wantedDeliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($wantedDeliveryTime) && !is_string($wantedDeliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wantedDeliveryTime, true), gettype($wantedDeliveryTime)), __LINE__);
        }
        if (is_null($wantedDeliveryTime) || (is_array($wantedDeliveryTime) && empty($wantedDeliveryTime))) {
            unset($this->wantedDeliveryTime);
        } else {
            $this->wantedDeliveryTime = $wantedDeliveryTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
