<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerInfo StructType
 * @subpackage Structs
 */
class CustomerInfo extends AbstractStructBase
{
    /**
     * The address1
     * @var string
     */
    public $address1;
    /**
     * The address2
     * @var string
     */
    public $address2;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $countryCode;
    /**
     * The creditApproved
     * @var bool
     */
    public $creditApproved;
    /**
     * The customerGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerGroup
     */
    public $customerGroup;
    /**
     * The deltaCustomerId
     * @var int
     */
    public $deltaCustomerId;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The listDiscounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Discount[]
     */
    public $listDiscounts;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The orgNo
     * @var string
     */
    public $orgNo;
    /**
     * The pckCustomerId
     * @var int
     */
    public $pckCustomerId;
    /**
     * The phoneNo
     * @var string
     */
    public $phoneNo;
    /**
     * The postCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postCity;
    /**
     * The postNo
     * @var string
     */
    public $postNo;
    /**
     * The welcomeMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $welcomeMessage;
    /**
     * Constructor method for customerInfo
     * @uses CustomerInfo::setAddress1()
     * @uses CustomerInfo::setAddress2()
     * @uses CustomerInfo::setCountryCode()
     * @uses CustomerInfo::setCreditApproved()
     * @uses CustomerInfo::setCustomerGroup()
     * @uses CustomerInfo::setDeltaCustomerId()
     * @uses CustomerInfo::setEmail()
     * @uses CustomerInfo::setListDiscounts()
     * @uses CustomerInfo::setName()
     * @uses CustomerInfo::setOrgNo()
     * @uses CustomerInfo::setPckCustomerId()
     * @uses CustomerInfo::setPhoneNo()
     * @uses CustomerInfo::setPostCity()
     * @uses CustomerInfo::setPostNo()
     * @uses CustomerInfo::setWelcomeMessage()
     * @param string $address1
     * @param string $address2
     * @param int $countryCode
     * @param bool $creditApproved
     * @param \StructType\CustomerGroup $customerGroup
     * @param int $deltaCustomerId
     * @param string $email
     * @param \StructType\Discount[] $listDiscounts
     * @param string $name
     * @param string $orgNo
     * @param int $pckCustomerId
     * @param string $phoneNo
     * @param string $postCity
     * @param string $postNo
     * @param string $welcomeMessage
     */
    public function __construct($address1 = null, $address2 = null, $countryCode = null, $creditApproved = null, \StructType\CustomerGroup $customerGroup = null, $deltaCustomerId = null, $email = null, array $listDiscounts = array(), $name = null, $orgNo = null, $pckCustomerId = null, $phoneNo = null, $postCity = null, $postNo = null, $welcomeMessage = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCountryCode($countryCode)
            ->setCreditApproved($creditApproved)
            ->setCustomerGroup($customerGroup)
            ->setDeltaCustomerId($deltaCustomerId)
            ->setEmail($email)
            ->setListDiscounts($listDiscounts)
            ->setName($name)
            ->setOrgNo($orgNo)
            ->setPckCustomerId($pckCustomerId)
            ->setPhoneNo($phoneNo)
            ->setPostCity($postCity)
            ->setPostNo($postNo)
            ->setWelcomeMessage($welcomeMessage);
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \StructType\CustomerInfo
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \StructType\CustomerInfo
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get countryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountryCode()
    {
        return isset($this->countryCode) ? $this->countryCode : null;
    }
    /**
     * Set countryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countryCode
     * @return \StructType\CustomerInfo
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: int
        if (!is_null($countryCode) && !(is_int($countryCode) || ctype_digit($countryCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->countryCode);
        } else {
            $this->countryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get creditApproved value
     * @return bool|null
     */
    public function getCreditApproved()
    {
        return $this->creditApproved;
    }
    /**
     * Set creditApproved value
     * @param bool $creditApproved
     * @return \StructType\CustomerInfo
     */
    public function setCreditApproved($creditApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($creditApproved) && !is_bool($creditApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($creditApproved, true), gettype($creditApproved)), __LINE__);
        }
        $this->creditApproved = $creditApproved;
        return $this;
    }
    /**
     * Get customerGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerGroup|null
     */
    public function getCustomerGroup()
    {
        return isset($this->customerGroup) ? $this->customerGroup : null;
    }
    /**
     * Set customerGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerGroup $customerGroup
     * @return \StructType\CustomerInfo
     */
    public function setCustomerGroup(\StructType\CustomerGroup $customerGroup = null)
    {
        if (is_null($customerGroup) || (is_array($customerGroup) && empty($customerGroup))) {
            unset($this->customerGroup);
        } else {
            $this->customerGroup = $customerGroup;
        }
        return $this;
    }
    /**
     * Get deltaCustomerId value
     * @return int|null
     */
    public function getDeltaCustomerId()
    {
        return $this->deltaCustomerId;
    }
    /**
     * Set deltaCustomerId value
     * @param int $deltaCustomerId
     * @return \StructType\CustomerInfo
     */
    public function setDeltaCustomerId($deltaCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($deltaCustomerId) && !(is_int($deltaCustomerId) || ctype_digit($deltaCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deltaCustomerId, true), gettype($deltaCustomerId)), __LINE__);
        }
        $this->deltaCustomerId = $deltaCustomerId;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CustomerInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get listDiscounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Discount[]|null
     */
    public function getListDiscounts()
    {
        return isset($this->listDiscounts) ? $this->listDiscounts : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListDiscounts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListDiscounts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListDiscountsForArrayConstraintsFromSetListDiscounts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerInfoListDiscountsItem) {
            // validation for constraint: itemType
            if (!$customerInfoListDiscountsItem instanceof \StructType\Discount) {
                $invalidValues[] = is_object($customerInfoListDiscountsItem) ? get_class($customerInfoListDiscountsItem) : sprintf('%s(%s)', gettype($customerInfoListDiscountsItem), var_export($customerInfoListDiscountsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listDiscounts property can only contain items of type \StructType\Discount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listDiscounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Discount[] $listDiscounts
     * @return \StructType\CustomerInfo
     */
    public function setListDiscounts(array $listDiscounts = array())
    {
        // validation for constraint: array
        if ('' !== ($listDiscountsArrayErrorMessage = self::validateListDiscountsForArrayConstraintsFromSetListDiscounts($listDiscounts))) {
            throw new \InvalidArgumentException($listDiscountsArrayErrorMessage, __LINE__);
        }
        if (is_null($listDiscounts) || (is_array($listDiscounts) && empty($listDiscounts))) {
            unset($this->listDiscounts);
        } else {
            $this->listDiscounts = $listDiscounts;
        }
        return $this;
    }
    /**
     * Add item to listDiscounts value
     * @throws \InvalidArgumentException
     * @param \StructType\Discount $item
     * @return \StructType\CustomerInfo
     */
    public function addToListDiscounts(\StructType\Discount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Discount) {
            throw new \InvalidArgumentException(sprintf('The listDiscounts property can only contain items of type \StructType\Discount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listDiscounts[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomerInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get orgNo value
     * @return string|null
     */
    public function getOrgNo()
    {
        return $this->orgNo;
    }
    /**
     * Set orgNo value
     * @param string $orgNo
     * @return \StructType\CustomerInfo
     */
    public function setOrgNo($orgNo = null)
    {
        // validation for constraint: string
        if (!is_null($orgNo) && !is_string($orgNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgNo, true), gettype($orgNo)), __LINE__);
        }
        $this->orgNo = $orgNo;
        return $this;
    }
    /**
     * Get pckCustomerId value
     * @return int|null
     */
    public function getPckCustomerId()
    {
        return $this->pckCustomerId;
    }
    /**
     * Set pckCustomerId value
     * @param int $pckCustomerId
     * @return \StructType\CustomerInfo
     */
    public function setPckCustomerId($pckCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($pckCustomerId) && !(is_int($pckCustomerId) || ctype_digit($pckCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pckCustomerId, true), gettype($pckCustomerId)), __LINE__);
        }
        $this->pckCustomerId = $pckCustomerId;
        return $this;
    }
    /**
     * Get phoneNo value
     * @return string|null
     */
    public function getPhoneNo()
    {
        return $this->phoneNo;
    }
    /**
     * Set phoneNo value
     * @param string $phoneNo
     * @return \StructType\CustomerInfo
     */
    public function setPhoneNo($phoneNo = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNo) && !is_string($phoneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNo, true), gettype($phoneNo)), __LINE__);
        }
        $this->phoneNo = $phoneNo;
        return $this;
    }
    /**
     * Get postCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCity()
    {
        return isset($this->postCity) ? $this->postCity : null;
    }
    /**
     * Set postCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCity
     * @return \StructType\CustomerInfo
     */
    public function setPostCity($postCity = null)
    {
        // validation for constraint: string
        if (!is_null($postCity) && !is_string($postCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCity, true), gettype($postCity)), __LINE__);
        }
        if (is_null($postCity) || (is_array($postCity) && empty($postCity))) {
            unset($this->postCity);
        } else {
            $this->postCity = $postCity;
        }
        return $this;
    }
    /**
     * Get postNo value
     * @return string|null
     */
    public function getPostNo()
    {
        return $this->postNo;
    }
    /**
     * Set postNo value
     * @param string $postNo
     * @return \StructType\CustomerInfo
     */
    public function setPostNo($postNo = null)
    {
        // validation for constraint: string
        if (!is_null($postNo) && !is_string($postNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postNo, true), gettype($postNo)), __LINE__);
        }
        $this->postNo = $postNo;
        return $this;
    }
    /**
     * Get welcomeMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWelcomeMessage()
    {
        return isset($this->welcomeMessage) ? $this->welcomeMessage : null;
    }
    /**
     * Set welcomeMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $welcomeMessage
     * @return \StructType\CustomerInfo
     */
    public function setWelcomeMessage($welcomeMessage = null)
    {
        // validation for constraint: string
        if (!is_null($welcomeMessage) && !is_string($welcomeMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($welcomeMessage, true), gettype($welcomeMessage)), __LINE__);
        }
        if (is_null($welcomeMessage) || (is_array($welcomeMessage) && empty($welcomeMessage))) {
            unset($this->welcomeMessage);
        } else {
            $this->welcomeMessage = $welcomeMessage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
