<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for creditOrder StructType
 * Meta informations extracted from the WSDL
 * - type: tns:creditOrder
 * @subpackage Structs
 */
class CreditOrder extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The orderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderId;
    /**
     * The orderLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderLineUpdate[]
     */
    public $orderLine;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for creditOrder
     * @uses CreditOrder::setLogin()
     * @uses CreditOrder::setPassword()
     * @uses CreditOrder::setOrderId()
     * @uses CreditOrder::setOrderLine()
     * @uses CreditOrder::setAmount()
     * @uses CreditOrder::setReason()
     * @param int $login
     * @param string $password
     * @param int $orderId
     * @param \StructType\OrderLineUpdate[] $orderLine
     * @param float $amount
     * @param string $reason
     */
    public function __construct($login = null, $password = null, $orderId = null, array $orderLine = array(), $amount = null, $reason = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setOrderId($orderId)
            ->setOrderLine($orderLine)
            ->setAmount($amount)
            ->setReason($reason);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\CreditOrder
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\CreditOrder
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\CreditOrder
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get orderLine value
     * @return \StructType\OrderLineUpdate[]|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderLineForArrayConstraintsFromSetOrderLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditOrderOrderLineItem) {
            // validation for constraint: itemType
            if (!$creditOrderOrderLineItem instanceof \StructType\OrderLineUpdate) {
                $invalidValues[] = is_object($creditOrderOrderLineItem) ? get_class($creditOrderOrderLineItem) : sprintf('%s(%s)', gettype($creditOrderOrderLineItem), var_export($creditOrderOrderLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderLine property can only contain items of type \StructType\OrderLineUpdate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderLine value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderLineUpdate[] $orderLine
     * @return \StructType\CreditOrder
     */
    public function setOrderLine(array $orderLine = array())
    {
        // validation for constraint: array
        if ('' !== ($orderLineArrayErrorMessage = self::validateOrderLineForArrayConstraintsFromSetOrderLine($orderLine))) {
            throw new \InvalidArgumentException($orderLineArrayErrorMessage, __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Add item to orderLine value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderLineUpdate $item
     * @return \StructType\CreditOrder
     */
    public function addToOrderLine(\StructType\OrderLineUpdate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderLineUpdate) {
            throw new \InvalidArgumentException(sprintf('The orderLine property can only contain items of type \StructType\OrderLineUpdate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderLine[] = $item;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CreditOrder
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\CreditOrder
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
