<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for articleGroup StructType
 * @subpackage Structs
 */
class ArticleGroup extends AbstractStructBase
{
    /**
     * The arcileGroupId
     * @var int
     */
    public $arcileGroupId;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The groupNumber
     * @var int
     */
    public $groupNumber;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for articleGroup
     * @uses ArticleGroup::setArcileGroupId()
     * @uses ArticleGroup::setDescription()
     * @uses ArticleGroup::setGroupNumber()
     * @uses ArticleGroup::setName()
     * @uses ArticleGroup::setTimestamp()
     * @param int $arcileGroupId
     * @param string $description
     * @param int $groupNumber
     * @param string $name
     * @param int $timestamp
     */
    public function __construct($arcileGroupId = null, $description = null, $groupNumber = null, $name = null, $timestamp = null)
    {
        $this
            ->setArcileGroupId($arcileGroupId)
            ->setDescription($description)
            ->setGroupNumber($groupNumber)
            ->setName($name)
            ->setTimestamp($timestamp);
    }
    /**
     * Get arcileGroupId value
     * @return int|null
     */
    public function getArcileGroupId()
    {
        return $this->arcileGroupId;
    }
    /**
     * Set arcileGroupId value
     * @param int $arcileGroupId
     * @return \StructType\ArticleGroup
     */
    public function setArcileGroupId($arcileGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($arcileGroupId) && !(is_int($arcileGroupId) || ctype_digit($arcileGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arcileGroupId, true), gettype($arcileGroupId)), __LINE__);
        }
        $this->arcileGroupId = $arcileGroupId;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\ArticleGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get groupNumber value
     * @return int|null
     */
    public function getGroupNumber()
    {
        return $this->groupNumber;
    }
    /**
     * Set groupNumber value
     * @param int $groupNumber
     * @return \StructType\ArticleGroup
     */
    public function setGroupNumber($groupNumber = null)
    {
        // validation for constraint: int
        if (!is_null($groupNumber) && !(is_int($groupNumber) || ctype_digit($groupNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupNumber, true), gettype($groupNumber)), __LINE__);
        }
        $this->groupNumber = $groupNumber;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ArticleGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\ArticleGroup
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArticleGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
