<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrders $parameters
     * @return \StructType\GetOrdersResponse|bool
     */
    public function getOrders(\StructType\GetOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCreditApplicants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCreditApplicants $parameters
     * @return \StructType\GetCreditApplicantsResponse|bool
     */
    public function getCreditApplicants(\StructType\GetCreditApplicants $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCreditApplicants($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWelcomeMailTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWelcomeMailTemplate $parameters
     * @return \StructType\GetWelcomeMailTemplateResponse|bool
     */
    public function getWelcomeMailTemplate(\StructType\GetWelcomeMailTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getWelcomeMailTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllPaymentTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllPaymentTypes $parameters
     * @return \StructType\GetAllPaymentTypesResponse|bool
     */
    public function getAllPaymentTypes(\StructType\GetAllPaymentTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAllPaymentTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReceiptURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReceiptURL $parameters
     * @return \StructType\GetReceiptURLResponse|bool
     */
    public function getReceiptURL(\StructType\GetReceiptURL $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getReceiptURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArticleURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArticleURL $parameters
     * @return \StructType\GetArticleURLResponse|bool
     */
    public function getArticleURL(\StructType\GetArticleURL $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getArticleURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderInfoURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderInfoURL $parameters
     * @return \StructType\GetOrderInfoURLResponse|bool
     */
    public function getOrderInfoURL(\StructType\GetOrderInfoURL $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderInfoURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatus $parameters
     * @return \StructType\GetStatusResponse|bool
     */
    public function getStatus(\StructType\GetStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllPaymentTypesResponse|\StructType\GetArticleURLResponse|\StructType\GetCreditApplicantsResponse|\StructType\GetOrderInfoURLResponse|\StructType\GetOrdersResponse|\StructType\GetReceiptURLResponse|\StructType\GetStatusResponse|\StructType\GetWelcomeMailTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
