<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webOrdersReturn StructType
 * @subpackage Structs
 */
class WebOrdersReturn extends AbstractStructBase
{
    /**
     * The insertUpdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsertUpdateResponse
     */
    public $insertUpdate;
    /**
     * The listWebOrders
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Order[]
     */
    public $listWebOrders;
    /**
     * Constructor method for webOrdersReturn
     * @uses WebOrdersReturn::setInsertUpdate()
     * @uses WebOrdersReturn::setListWebOrders()
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @param \StructType\Order[] $listWebOrders
     */
    public function __construct(\StructType\InsertUpdateResponse $insertUpdate = null, array $listWebOrders = array())
    {
        $this
            ->setInsertUpdate($insertUpdate)
            ->setListWebOrders($listWebOrders);
    }
    /**
     * Get insertUpdate value
     * @return \StructType\InsertUpdateResponse|null
     */
    public function getInsertUpdate()
    {
        return $this->insertUpdate;
    }
    /**
     * Set insertUpdate value
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @return \StructType\WebOrdersReturn
     */
    public function setInsertUpdate(\StructType\InsertUpdateResponse $insertUpdate = null)
    {
        $this->insertUpdate = $insertUpdate;
        return $this;
    }
    /**
     * Get listWebOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Order[]|null
     */
    public function getListWebOrders()
    {
        return isset($this->listWebOrders) ? $this->listWebOrders : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListWebOrders method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListWebOrders method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListWebOrdersForArrayConstraintsFromSetListWebOrders(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webOrdersReturnListWebOrdersItem) {
            // validation for constraint: itemType
            if (!$webOrdersReturnListWebOrdersItem instanceof \StructType\Order) {
                $invalidValues[] = is_object($webOrdersReturnListWebOrdersItem) ? get_class($webOrdersReturnListWebOrdersItem) : sprintf('%s(%s)', gettype($webOrdersReturnListWebOrdersItem), var_export($webOrdersReturnListWebOrdersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listWebOrders property can only contain items of type \StructType\Order, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listWebOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Order[] $listWebOrders
     * @return \StructType\WebOrdersReturn
     */
    public function setListWebOrders(array $listWebOrders = array())
    {
        // validation for constraint: array
        if ('' !== ($listWebOrdersArrayErrorMessage = self::validateListWebOrdersForArrayConstraintsFromSetListWebOrders($listWebOrders))) {
            throw new \InvalidArgumentException($listWebOrdersArrayErrorMessage, __LINE__);
        }
        if (is_null($listWebOrders) || (is_array($listWebOrders) && empty($listWebOrders))) {
            unset($this->listWebOrders);
        } else {
            $this->listWebOrders = $listWebOrders;
        }
        return $this;
    }
    /**
     * Add item to listWebOrders value
     * @throws \InvalidArgumentException
     * @param \StructType\Order $item
     * @return \StructType\WebOrdersReturn
     */
    public function addToListWebOrders(\StructType\Order $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order) {
            throw new \InvalidArgumentException(sprintf('The listWebOrders property can only contain items of type \StructType\Order, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listWebOrders[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebOrdersReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
