<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateOrder StructType
 * @subpackage Structs
 */
class UpdateOrder extends AbstractStructBase
{
    /**
     * The deltaOrderId
     * @var int
     */
    public $deltaOrderId;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The orderLines
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderLineUpdate[]
     */
    public $orderLines;
    /**
     * The orderStatusId
     * @var int
     */
    public $orderStatusId;
    /**
     * The packageNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageNo;
    /**
     * The packtrackURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packtrackURL;
    /**
     * The sendId
     * @var int
     */
    public $sendId;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * The transporterName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transporterName;
    /**
     * Constructor method for updateOrder
     * @uses UpdateOrder::setDeltaOrderId()
     * @uses UpdateOrder::setMessage()
     * @uses UpdateOrder::setOrderLines()
     * @uses UpdateOrder::setOrderStatusId()
     * @uses UpdateOrder::setPackageNo()
     * @uses UpdateOrder::setPacktrackURL()
     * @uses UpdateOrder::setSendId()
     * @uses UpdateOrder::setTimestamp()
     * @uses UpdateOrder::setTransporterName()
     * @param int $deltaOrderId
     * @param string $message
     * @param \StructType\OrderLineUpdate[] $orderLines
     * @param int $orderStatusId
     * @param string $packageNo
     * @param string $packtrackURL
     * @param int $sendId
     * @param int $timestamp
     * @param string $transporterName
     */
    public function __construct($deltaOrderId = null, $message = null, array $orderLines = array(), $orderStatusId = null, $packageNo = null, $packtrackURL = null, $sendId = null, $timestamp = null, $transporterName = null)
    {
        $this
            ->setDeltaOrderId($deltaOrderId)
            ->setMessage($message)
            ->setOrderLines($orderLines)
            ->setOrderStatusId($orderStatusId)
            ->setPackageNo($packageNo)
            ->setPacktrackURL($packtrackURL)
            ->setSendId($sendId)
            ->setTimestamp($timestamp)
            ->setTransporterName($transporterName);
    }
    /**
     * Get deltaOrderId value
     * @return int|null
     */
    public function getDeltaOrderId()
    {
        return $this->deltaOrderId;
    }
    /**
     * Set deltaOrderId value
     * @param int $deltaOrderId
     * @return \StructType\UpdateOrder
     */
    public function setDeltaOrderId($deltaOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($deltaOrderId) && !(is_int($deltaOrderId) || ctype_digit($deltaOrderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deltaOrderId, true), gettype($deltaOrderId)), __LINE__);
        }
        $this->deltaOrderId = $deltaOrderId;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\UpdateOrder
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get orderLines value
     * @return \StructType\OrderLineUpdate[]|null
     */
    public function getOrderLines()
    {
        return $this->orderLines;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderLinesForArrayConstraintsFromSetOrderLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateOrderOrderLinesItem) {
            // validation for constraint: itemType
            if (!$updateOrderOrderLinesItem instanceof \StructType\OrderLineUpdate) {
                $invalidValues[] = is_object($updateOrderOrderLinesItem) ? get_class($updateOrderOrderLinesItem) : sprintf('%s(%s)', gettype($updateOrderOrderLinesItem), var_export($updateOrderOrderLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderLines property can only contain items of type \StructType\OrderLineUpdate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderLines value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderLineUpdate[] $orderLines
     * @return \StructType\UpdateOrder
     */
    public function setOrderLines(array $orderLines = array())
    {
        // validation for constraint: array
        if ('' !== ($orderLinesArrayErrorMessage = self::validateOrderLinesForArrayConstraintsFromSetOrderLines($orderLines))) {
            throw new \InvalidArgumentException($orderLinesArrayErrorMessage, __LINE__);
        }
        $this->orderLines = $orderLines;
        return $this;
    }
    /**
     * Add item to orderLines value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderLineUpdate $item
     * @return \StructType\UpdateOrder
     */
    public function addToOrderLines(\StructType\OrderLineUpdate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderLineUpdate) {
            throw new \InvalidArgumentException(sprintf('The orderLines property can only contain items of type \StructType\OrderLineUpdate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderLines[] = $item;
        return $this;
    }
    /**
     * Get orderStatusId value
     * @return int|null
     */
    public function getOrderStatusId()
    {
        return $this->orderStatusId;
    }
    /**
     * Set orderStatusId value
     * @param int $orderStatusId
     * @return \StructType\UpdateOrder
     */
    public function setOrderStatusId($orderStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($orderStatusId) && !(is_int($orderStatusId) || ctype_digit($orderStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderStatusId, true), gettype($orderStatusId)), __LINE__);
        }
        $this->orderStatusId = $orderStatusId;
        return $this;
    }
    /**
     * Get packageNo value
     * @return string|null
     */
    public function getPackageNo()
    {
        return $this->packageNo;
    }
    /**
     * Set packageNo value
     * @param string $packageNo
     * @return \StructType\UpdateOrder
     */
    public function setPackageNo($packageNo = null)
    {
        // validation for constraint: string
        if (!is_null($packageNo) && !is_string($packageNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageNo, true), gettype($packageNo)), __LINE__);
        }
        $this->packageNo = $packageNo;
        return $this;
    }
    /**
     * Get packtrackURL value
     * @return string|null
     */
    public function getPacktrackURL()
    {
        return $this->packtrackURL;
    }
    /**
     * Set packtrackURL value
     * @param string $packtrackURL
     * @return \StructType\UpdateOrder
     */
    public function setPacktrackURL($packtrackURL = null)
    {
        // validation for constraint: string
        if (!is_null($packtrackURL) && !is_string($packtrackURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packtrackURL, true), gettype($packtrackURL)), __LINE__);
        }
        $this->packtrackURL = $packtrackURL;
        return $this;
    }
    /**
     * Get sendId value
     * @return int|null
     */
    public function getSendId()
    {
        return $this->sendId;
    }
    /**
     * Set sendId value
     * @param int $sendId
     * @return \StructType\UpdateOrder
     */
    public function setSendId($sendId = null)
    {
        // validation for constraint: int
        if (!is_null($sendId) && !(is_int($sendId) || ctype_digit($sendId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sendId, true), gettype($sendId)), __LINE__);
        }
        $this->sendId = $sendId;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\UpdateOrder
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get transporterName value
     * @return string|null
     */
    public function getTransporterName()
    {
        return $this->transporterName;
    }
    /**
     * Set transporterName value
     * @param string $transporterName
     * @return \StructType\UpdateOrder
     */
    public function setTransporterName($transporterName = null)
    {
        // validation for constraint: string
        if (!is_null($transporterName) && !is_string($transporterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transporterName, true), gettype($transporterName)), __LINE__);
        }
        $this->transporterName = $transporterName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
