<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stockDetail StructType
 * @subpackage Structs
 */
class StockDetail extends AbstractStructBase
{
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The warehouseId
     * @var int
     */
    public $warehouseId;
    /**
     * Constructor method for stockDetail
     * @uses StockDetail::setCount()
     * @uses StockDetail::setWarehouseId()
     * @param int $count
     * @param int $warehouseId
     */
    public function __construct($count = null, $warehouseId = null)
    {
        $this
            ->setCount($count)
            ->setWarehouseId($warehouseId);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\StockDetail
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get warehouseId value
     * @return int|null
     */
    public function getWarehouseId()
    {
        return $this->warehouseId;
    }
    /**
     * Set warehouseId value
     * @param int $warehouseId
     * @return \StructType\StockDetail
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseId) && !(is_int($warehouseId) || ctype_digit($warehouseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warehouseId, true), gettype($warehouseId)), __LINE__);
        }
        $this->warehouseId = $warehouseId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
