<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sizeColor StructType
 * @subpackage Structs
 */
class SizeColor extends AbstractStructBase
{
    /**
     * The color
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Color
     */
    public $color;
    /**
     * The confirmedDelivery
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $confirmedDelivery;
    /**
     * The eans
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $eans;
    /**
     * The expectedDeliveryAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $expectedDeliveryAmount;
    /**
     * The expectedDeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $expectedDeliveryDate;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $info;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Size
     */
    public $size;
    /**
     * The sizeColorId
     * @var int
     */
    public $sizeColorId;
    /**
     * The sizeColorInUse
     * @var bool
     */
    public $sizeColorInUse;
    /**
     * The stockCount
     * @var int
     */
    public $stockCount;
    /**
     * The stockDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockDetail[]
     */
    public $stockDetails;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for sizeColor
     * @uses SizeColor::setColor()
     * @uses SizeColor::setConfirmedDelivery()
     * @uses SizeColor::setEans()
     * @uses SizeColor::setExpectedDeliveryAmount()
     * @uses SizeColor::setExpectedDeliveryDate()
     * @uses SizeColor::setInfo()
     * @uses SizeColor::setSize()
     * @uses SizeColor::setSizeColorId()
     * @uses SizeColor::setSizeColorInUse()
     * @uses SizeColor::setStockCount()
     * @uses SizeColor::setStockDetails()
     * @uses SizeColor::setTimestamp()
     * @param \StructType\Color $color
     * @param bool $confirmedDelivery
     * @param string[] $eans
     * @param int $expectedDeliveryAmount
     * @param string $expectedDeliveryDate
     * @param string $info
     * @param \StructType\Size $size
     * @param int $sizeColorId
     * @param bool $sizeColorInUse
     * @param int $stockCount
     * @param \StructType\StockDetail[] $stockDetails
     * @param int $timestamp
     */
    public function __construct(\StructType\Color $color = null, $confirmedDelivery = null, array $eans = array(), $expectedDeliveryAmount = null, $expectedDeliveryDate = null, $info = null, \StructType\Size $size = null, $sizeColorId = null, $sizeColorInUse = null, $stockCount = null, array $stockDetails = array(), $timestamp = null)
    {
        $this
            ->setColor($color)
            ->setConfirmedDelivery($confirmedDelivery)
            ->setEans($eans)
            ->setExpectedDeliveryAmount($expectedDeliveryAmount)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setInfo($info)
            ->setSize($size)
            ->setSizeColorId($sizeColorId)
            ->setSizeColorInUse($sizeColorInUse)
            ->setStockCount($stockCount)
            ->setStockDetails($stockDetails)
            ->setTimestamp($timestamp);
    }
    /**
     * Get color value
     * @return \StructType\Color|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param \StructType\Color $color
     * @return \StructType\SizeColor
     */
    public function setColor(\StructType\Color $color = null)
    {
        $this->color = $color;
        return $this;
    }
    /**
     * Get confirmedDelivery value
     * @return bool|null
     */
    public function getConfirmedDelivery()
    {
        return $this->confirmedDelivery;
    }
    /**
     * Set confirmedDelivery value
     * @param bool $confirmedDelivery
     * @return \StructType\SizeColor
     */
    public function setConfirmedDelivery($confirmedDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmedDelivery) && !is_bool($confirmedDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmedDelivery, true), gettype($confirmedDelivery)), __LINE__);
        }
        $this->confirmedDelivery = $confirmedDelivery;
        return $this;
    }
    /**
     * Get eans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getEans()
    {
        return isset($this->eans) ? $this->eans : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEansForArrayConstraintsFromSetEans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sizeColorEansItem) {
            // validation for constraint: itemType
            if (!is_string($sizeColorEansItem)) {
                $invalidValues[] = is_object($sizeColorEansItem) ? get_class($sizeColorEansItem) : sprintf('%s(%s)', gettype($sizeColorEansItem), var_export($sizeColorEansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eans property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $eans
     * @return \StructType\SizeColor
     */
    public function setEans(array $eans = array())
    {
        // validation for constraint: array
        if ('' !== ($eansArrayErrorMessage = self::validateEansForArrayConstraintsFromSetEans($eans))) {
            throw new \InvalidArgumentException($eansArrayErrorMessage, __LINE__);
        }
        if (is_null($eans) || (is_array($eans) && empty($eans))) {
            unset($this->eans);
        } else {
            $this->eans = $eans;
        }
        return $this;
    }
    /**
     * Add item to eans value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SizeColor
     */
    public function addToEans($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The eans property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eans[] = $item;
        return $this;
    }
    /**
     * Get expectedDeliveryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpectedDeliveryAmount()
    {
        return isset($this->expectedDeliveryAmount) ? $this->expectedDeliveryAmount : null;
    }
    /**
     * Set expectedDeliveryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expectedDeliveryAmount
     * @return \StructType\SizeColor
     */
    public function setExpectedDeliveryAmount($expectedDeliveryAmount = null)
    {
        // validation for constraint: int
        if (!is_null($expectedDeliveryAmount) && !(is_int($expectedDeliveryAmount) || ctype_digit($expectedDeliveryAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expectedDeliveryAmount, true), gettype($expectedDeliveryAmount)), __LINE__);
        }
        if (is_null($expectedDeliveryAmount) || (is_array($expectedDeliveryAmount) && empty($expectedDeliveryAmount))) {
            unset($this->expectedDeliveryAmount);
        } else {
            $this->expectedDeliveryAmount = $expectedDeliveryAmount;
        }
        return $this;
    }
    /**
     * Get expectedDeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpectedDeliveryDate()
    {
        return isset($this->expectedDeliveryDate) ? $this->expectedDeliveryDate : null;
    }
    /**
     * Set expectedDeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expectedDeliveryDate
     * @return \StructType\SizeColor
     */
    public function setExpectedDeliveryDate($expectedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDeliveryDate) && !is_string($expectedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedDeliveryDate, true), gettype($expectedDeliveryDate)), __LINE__);
        }
        if (is_null($expectedDeliveryDate) || (is_array($expectedDeliveryDate) && empty($expectedDeliveryDate))) {
            unset($this->expectedDeliveryDate);
        } else {
            $this->expectedDeliveryDate = $expectedDeliveryDate;
        }
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info
     * @return \StructType\SizeColor
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Get size value
     * @return \StructType\Size|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param \StructType\Size $size
     * @return \StructType\SizeColor
     */
    public function setSize(\StructType\Size $size = null)
    {
        $this->size = $size;
        return $this;
    }
    /**
     * Get sizeColorId value
     * @return int|null
     */
    public function getSizeColorId()
    {
        return $this->sizeColorId;
    }
    /**
     * Set sizeColorId value
     * @param int $sizeColorId
     * @return \StructType\SizeColor
     */
    public function setSizeColorId($sizeColorId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeColorId) && !(is_int($sizeColorId) || ctype_digit($sizeColorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeColorId, true), gettype($sizeColorId)), __LINE__);
        }
        $this->sizeColorId = $sizeColorId;
        return $this;
    }
    /**
     * Get sizeColorInUse value
     * @return bool|null
     */
    public function getSizeColorInUse()
    {
        return $this->sizeColorInUse;
    }
    /**
     * Set sizeColorInUse value
     * @param bool $sizeColorInUse
     * @return \StructType\SizeColor
     */
    public function setSizeColorInUse($sizeColorInUse = null)
    {
        // validation for constraint: boolean
        if (!is_null($sizeColorInUse) && !is_bool($sizeColorInUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sizeColorInUse, true), gettype($sizeColorInUse)), __LINE__);
        }
        $this->sizeColorInUse = $sizeColorInUse;
        return $this;
    }
    /**
     * Get stockCount value
     * @return int|null
     */
    public function getStockCount()
    {
        return $this->stockCount;
    }
    /**
     * Set stockCount value
     * @param int $stockCount
     * @return \StructType\SizeColor
     */
    public function setStockCount($stockCount = null)
    {
        // validation for constraint: int
        if (!is_null($stockCount) && !(is_int($stockCount) || ctype_digit($stockCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockCount, true), gettype($stockCount)), __LINE__);
        }
        $this->stockCount = $stockCount;
        return $this;
    }
    /**
     * Get stockDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockDetail[]|null
     */
    public function getStockDetails()
    {
        return isset($this->stockDetails) ? $this->stockDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStockDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockDetailsForArrayConstraintsFromSetStockDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sizeColorStockDetailsItem) {
            // validation for constraint: itemType
            if (!$sizeColorStockDetailsItem instanceof \StructType\StockDetail) {
                $invalidValues[] = is_object($sizeColorStockDetailsItem) ? get_class($sizeColorStockDetailsItem) : sprintf('%s(%s)', gettype($sizeColorStockDetailsItem), var_export($sizeColorStockDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockDetails property can only contain items of type \StructType\StockDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockDetail[] $stockDetails
     * @return \StructType\SizeColor
     */
    public function setStockDetails(array $stockDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($stockDetailsArrayErrorMessage = self::validateStockDetailsForArrayConstraintsFromSetStockDetails($stockDetails))) {
            throw new \InvalidArgumentException($stockDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($stockDetails) || (is_array($stockDetails) && empty($stockDetails))) {
            unset($this->stockDetails);
        } else {
            $this->stockDetails = $stockDetails;
        }
        return $this;
    }
    /**
     * Add item to stockDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\StockDetail $item
     * @return \StructType\SizeColor
     */
    public function addToStockDetails(\StructType\StockDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockDetail) {
            throw new \InvalidArgumentException(sprintf('The stockDetails property can only contain items of type \StructType\StockDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockDetails[] = $item;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\SizeColor
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SizeColor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
