<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendColor StructType
 * Meta informations extracted from the WSDL
 * - type: tns:sendColor
 * @subpackage Structs
 */
class SendColor extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Color
     */
    public $color;
    /**
     * Constructor method for sendColor
     * @uses SendColor::setLogin()
     * @uses SendColor::setPassword()
     * @uses SendColor::setColor()
     * @param int $login
     * @param string $password
     * @param \StructType\Color $color
     */
    public function __construct($login = null, $password = null, \StructType\Color $color = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setColor($color);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendColor
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendColor
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get color value
     * @return \StructType\Color|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param \StructType\Color $color
     * @return \StructType\SendColor
     */
    public function setColor(\StructType\Color $color = null)
    {
        $this->color = $color;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendColor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
