<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getArticleURL StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getArticleURL
 * @subpackage Structs
 */
class GetArticleURL extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pckid
     * @var int
     */
    public $pckid;
    /**
     * Constructor method for getArticleURL
     * @uses GetArticleURL::setLogin()
     * @uses GetArticleURL::setPassword()
     * @uses GetArticleURL::setPckid()
     * @param int $login
     * @param string $password
     * @param int $pckid
     */
    public function __construct($login = null, $password = null, $pckid = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setPckid($pckid);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\GetArticleURL
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetArticleURL
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pckid value
     * @return int|null
     */
    public function getPckid()
    {
        return $this->pckid;
    }
    /**
     * Set pckid value
     * @param int $pckid
     * @return \StructType\GetArticleURL
     */
    public function setPckid($pckid = null)
    {
        // validation for constraint: int
        if (!is_null($pckid) && !(is_int($pckid) || ctype_digit($pckid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pckid, true), gettype($pckid)), __LINE__);
        }
        $this->pckid = $pckid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetArticleURL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
