<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The contactId
     * @var int
     */
    public $contactId;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The invoiceAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceAddress;
    /**
     * The invoiceAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceAddress2;
    /**
     * The invoiceOnEmail
     * @var bool
     */
    public $invoiceOnEmail;
    /**
     * The invoicePostCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoicePostCity;
    /**
     * The invoicePostNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoicePostNo;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The orgNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orgNo;
    /**
     * The phone1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone1;
    /**
     * Constructor method for customer
     * @uses Customer::setContactId()
     * @uses Customer::setEmail()
     * @uses Customer::setFax()
     * @uses Customer::setInvoiceAddress()
     * @uses Customer::setInvoiceAddress2()
     * @uses Customer::setInvoiceOnEmail()
     * @uses Customer::setInvoicePostCity()
     * @uses Customer::setInvoicePostNo()
     * @uses Customer::setName()
     * @uses Customer::setOrgNo()
     * @uses Customer::setPhone1()
     * @param int $contactId
     * @param string $email
     * @param string $fax
     * @param string $invoiceAddress
     * @param string $invoiceAddress2
     * @param bool $invoiceOnEmail
     * @param string $invoicePostCity
     * @param string $invoicePostNo
     * @param string $name
     * @param string $orgNo
     * @param string $phone1
     */
    public function __construct($contactId = null, $email = null, $fax = null, $invoiceAddress = null, $invoiceAddress2 = null, $invoiceOnEmail = null, $invoicePostCity = null, $invoicePostNo = null, $name = null, $orgNo = null, $phone1 = null)
    {
        $this
            ->setContactId($contactId)
            ->setEmail($email)
            ->setFax($fax)
            ->setInvoiceAddress($invoiceAddress)
            ->setInvoiceAddress2($invoiceAddress2)
            ->setInvoiceOnEmail($invoiceOnEmail)
            ->setInvoicePostCity($invoicePostCity)
            ->setInvoicePostNo($invoicePostNo)
            ->setName($name)
            ->setOrgNo($orgNo)
            ->setPhone1($phone1);
    }
    /**
     * Get contactId value
     * @return int|null
     */
    public function getContactId()
    {
        return $this->contactId;
    }
    /**
     * Set contactId value
     * @param int $contactId
     * @return \StructType\Customer
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->contactId = $contactId;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Customer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Customer
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get invoiceAddress value
     * @return string|null
     */
    public function getInvoiceAddress()
    {
        return $this->invoiceAddress;
    }
    /**
     * Set invoiceAddress value
     * @param string $invoiceAddress
     * @return \StructType\Customer
     */
    public function setInvoiceAddress($invoiceAddress = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress) && !is_string($invoiceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress, true), gettype($invoiceAddress)), __LINE__);
        }
        $this->invoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get invoiceAddress2 value
     * @return string|null
     */
    public function getInvoiceAddress2()
    {
        return $this->invoiceAddress2;
    }
    /**
     * Set invoiceAddress2 value
     * @param string $invoiceAddress2
     * @return \StructType\Customer
     */
    public function setInvoiceAddress2($invoiceAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress2) && !is_string($invoiceAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress2, true), gettype($invoiceAddress2)), __LINE__);
        }
        $this->invoiceAddress2 = $invoiceAddress2;
        return $this;
    }
    /**
     * Get invoiceOnEmail value
     * @return bool|null
     */
    public function getInvoiceOnEmail()
    {
        return $this->invoiceOnEmail;
    }
    /**
     * Set invoiceOnEmail value
     * @param bool $invoiceOnEmail
     * @return \StructType\Customer
     */
    public function setInvoiceOnEmail($invoiceOnEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoiceOnEmail) && !is_bool($invoiceOnEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoiceOnEmail, true), gettype($invoiceOnEmail)), __LINE__);
        }
        $this->invoiceOnEmail = $invoiceOnEmail;
        return $this;
    }
    /**
     * Get invoicePostCity value
     * @return string|null
     */
    public function getInvoicePostCity()
    {
        return $this->invoicePostCity;
    }
    /**
     * Set invoicePostCity value
     * @param string $invoicePostCity
     * @return \StructType\Customer
     */
    public function setInvoicePostCity($invoicePostCity = null)
    {
        // validation for constraint: string
        if (!is_null($invoicePostCity) && !is_string($invoicePostCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicePostCity, true), gettype($invoicePostCity)), __LINE__);
        }
        $this->invoicePostCity = $invoicePostCity;
        return $this;
    }
    /**
     * Get invoicePostNo value
     * @return string|null
     */
    public function getInvoicePostNo()
    {
        return $this->invoicePostNo;
    }
    /**
     * Set invoicePostNo value
     * @param string $invoicePostNo
     * @return \StructType\Customer
     */
    public function setInvoicePostNo($invoicePostNo = null)
    {
        // validation for constraint: string
        if (!is_null($invoicePostNo) && !is_string($invoicePostNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicePostNo, true), gettype($invoicePostNo)), __LINE__);
        }
        $this->invoicePostNo = $invoicePostNo;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Customer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get orgNo value
     * @return string|null
     */
    public function getOrgNo()
    {
        return $this->orgNo;
    }
    /**
     * Set orgNo value
     * @param string $orgNo
     * @return \StructType\Customer
     */
    public function setOrgNo($orgNo = null)
    {
        // validation for constraint: string
        if (!is_null($orgNo) && !is_string($orgNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgNo, true), gettype($orgNo)), __LINE__);
        }
        $this->orgNo = $orgNo;
        return $this;
    }
    /**
     * Get phone1 value
     * @return string|null
     */
    public function getPhone1()
    {
        return $this->phone1;
    }
    /**
     * Set phone1 value
     * @param string $phone1
     * @return \StructType\Customer
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        $this->phone1 = $phone1;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
