<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShipmentNumber StructType
 * @subpackage Structs
 */
class GetShipmentNumber extends AbstractStructBase
{
    /**
     * The iType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iType;
    /**
     * The Credential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetShipmentNumber
     * @uses GetShipmentNumber::setIType()
     * @uses GetShipmentNumber::setCredential()
     * @param int $iType
     * @param \StructType\ClsCredential $credential
     */
    public function __construct($iType = null, \StructType\ClsCredential $credential = null)
    {
        $this
            ->setIType($iType)
            ->setCredential($credential);
    }
    /**
     * Get iType value
     * @return int|null
     */
    public function getIType()
    {
        return $this->iType;
    }
    /**
     * Set iType value
     * @param int $iType
     * @return \StructType\GetShipmentNumber
     */
    public function setIType($iType = null)
    {
        // validation for constraint: int
        if (!is_null($iType) && !(is_int($iType) || ctype_digit($iType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iType, true), gettype($iType)), __LINE__);
        }
        $this->iType = $iType;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClsCredential $credential
     * @return \StructType\GetShipmentNumber
     */
    public function setCredential(\StructType\ClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipmentNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
