<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckSpecials StructType
 * @subpackage Structs
 */
class CheckSpecials extends AbstractStructBase
{
    /**
     * The Special1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Special1;
    /**
     * The Special2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Special2;
    /**
     * The Credential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsCredential
     */
    public $Credential;
    /**
     * Constructor method for CheckSpecials
     * @uses CheckSpecials::setSpecial1()
     * @uses CheckSpecials::setSpecial2()
     * @uses CheckSpecials::setCredential()
     * @param string $special1
     * @param string $special2
     * @param \StructType\ClsCredential $credential
     */
    public function __construct($special1 = null, $special2 = null, \StructType\ClsCredential $credential = null)
    {
        $this
            ->setSpecial1($special1)
            ->setSpecial2($special2)
            ->setCredential($credential);
    }
    /**
     * Get Special1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecial1()
    {
        return isset($this->Special1) ? $this->Special1 : null;
    }
    /**
     * Set Special1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $special1
     * @return \StructType\CheckSpecials
     */
    public function setSpecial1($special1 = null)
    {
        // validation for constraint: string
        if (!is_null($special1) && !is_string($special1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($special1, true), gettype($special1)), __LINE__);
        }
        if (is_null($special1) || (is_array($special1) && empty($special1))) {
            unset($this->Special1);
        } else {
            $this->Special1 = $special1;
        }
        return $this;
    }
    /**
     * Get Special2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecial2()
    {
        return isset($this->Special2) ? $this->Special2 : null;
    }
    /**
     * Set Special2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $special2
     * @return \StructType\CheckSpecials
     */
    public function setSpecial2($special2 = null)
    {
        // validation for constraint: string
        if (!is_null($special2) && !is_string($special2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($special2, true), gettype($special2)), __LINE__);
        }
        if (is_null($special2) || (is_array($special2) && empty($special2))) {
            unset($this->Special2);
        } else {
            $this->Special2 = $special2;
        }
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClsCredential $credential
     * @return \StructType\CheckSpecials
     */
    public function setCredential(\StructType\ClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckSpecials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
