<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetShipmentNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentNumber $parameters
     * @return \StructType\GetShipmentNumberResponse|bool
     */
    public function GetShipmentNumber(\StructType\GetShipmentNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetShipmentNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucher $parameters
     * @return \StructType\GetVoucherResponse|bool
     */
    public function GetVoucher(\StructType\GetVoucher $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherMargins
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherMargins $parameters
     * @return \StructType\GetVoucherMarginsResponse|bool
     */
    public function GetVoucherMargins(\StructType\GetVoucherMargins $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherMargins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherTracking $parameters
     * @return \StructType\GetVoucherTrackingResponse|bool
     */
    public function GetVoucherTracking(\StructType\GetVoucherTracking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTrackingLanguage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherTrackingLanguage $parameters
     * @return \StructType\GetVoucherTrackingLanguageResponse|bool
     */
    public function GetVoucherTrackingLanguage(\StructType\GetVoucherTrackingLanguage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherTrackingLanguage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTracking_Station
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherTracking_Station $parameters
     * @return \StructType\GetVoucherTracking_StationResponse|bool
     */
    public function GetVoucherTracking_Station(\StructType\GetVoucherTracking_Station $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherTracking_Station($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersTracking_By_TimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersTracking_By_TimePeriod $parameters
     * @return \StructType\GetVouchersTracking_By_TimePeriodResponse|bool
     */
    public function GetVouchersTracking_By_TimePeriod(\StructType\GetVouchersTracking_By_TimePeriod $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersTracking_By_TimePeriod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersTracking_By_TimePeriod2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersTracking_By_TimePeriod2 $parameters
     * @return \StructType\GetVouchersTracking_By_TimePeriod2Response|bool
     */
    public function GetVouchersTracking_By_TimePeriod2(\StructType\GetVouchersTracking_By_TimePeriod2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersTracking_By_TimePeriod2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersTracking_By_ItemID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersTracking_By_ItemID $parameters
     * @return \StructType\GetVouchersTracking_By_ItemIDResponse|bool
     */
    public function GetVouchersTracking_By_ItemID(\StructType\GetVouchersTracking_By_ItemID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersTracking_By_ItemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTracking_By_ItemID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherTracking_By_ItemID $parameters
     * @return \StructType\GetVoucherTracking_By_ItemIDResponse|bool
     */
    public function GetVoucherTracking_By_ItemID(\StructType\GetVoucherTracking_By_ItemID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherTracking_By_ItemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersXps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersXps $parameters
     * @return \StructType\GetVouchersXpsResponse|bool
     */
    public function GetVouchersXps(\StructType\GetVouchersXps $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersXps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersXps_Url
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersXps_Url $parameters
     * @return \StructType\GetVouchersXps_UrlResponse|bool
     */
    public function GetVouchersXps_Url(\StructType\GetVouchersXps_Url $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersXps_Url($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersPdf $parameters
     * @return \StructType\GetVouchersPdfResponse|bool
     */
    public function GetVouchersPdf(\StructType\GetVouchersPdf $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf_Url
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersPdf_Url $parameters
     * @return \StructType\GetVouchersPdf_UrlResponse|bool
     */
    public function GetVouchersPdf_Url(\StructType\GetVouchersPdf_Url $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersPdf_Url($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchers_Str_Pdf_Url
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchers_Str_Pdf_Url $parameters
     * @return \StructType\GetVouchers_Str_Pdf_UrlResponse|bool
     */
    public function GetVouchers_Str_Pdf_Url(\StructType\GetVouchers_Str_Pdf_Url $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchers_Str_Pdf_Url($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf2A4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchersPdf2A4 $parameters
     * @return \StructType\GetVouchersPdf2A4Response|bool
     */
    public function GetVouchersPdf2A4(\StructType\GetVouchersPdf2A4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVouchersPdf2A4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPOD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherPOD $parameters
     * @return \StructType\GetVoucherPODResponse|bool
     */
    public function GetVoucherPOD(\StructType\GetVoucherPOD $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherPOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFA6Margins
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherPDFA6Margins $parameters
     * @return \StructType\GetVoucherPDFA6MarginsResponse|bool
     */
    public function GetVoucherPDFA6Margins(\StructType\GetVoucherPDFA6Margins $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherPDFA6Margins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFMargins
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherPDFMargins $parameters
     * @return \StructType\GetVoucherPDFMarginsResponse|bool
     */
    public function GetVoucherPDFMargins(\StructType\GetVoucherPDFMargins $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherPDFMargins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFA4Double
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherPDFA4Double $parameters
     * @return \StructType\GetVoucherPDFA4DoubleResponse|bool
     */
    public function GetVoucherPDFA4Double(\StructType\GetVoucherPDFA4Double $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoucherPDFA4Double($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetShipmentNumberResponse|\StructType\GetVoucherMarginsResponse|\StructType\GetVoucherPDFA4DoubleResponse|\StructType\GetVoucherPDFA6MarginsResponse|\StructType\GetVoucherPDFMarginsResponse|\StructType\GetVoucherPODResponse|\StructType\GetVoucherResponse|\StructType\GetVouchersPdf2A4Response|\StructType\GetVouchersPdfResponse|\StructType\GetVouchersPdf_UrlResponse|\StructType\GetVouchersTracking_By_ItemIDResponse|\StructType\GetVouchersTracking_By_TimePeriod2Response|\StructType\GetVouchersTracking_By_TimePeriodResponse|\StructType\GetVouchersXpsResponse|\StructType\GetVouchersXps_UrlResponse|\StructType\GetVouchers_Str_Pdf_UrlResponse|\StructType\GetVoucherTrackingLanguageResponse|\StructType\GetVoucherTrackingResponse|\StructType\GetVoucherTracking_By_ItemIDResponse|\StructType\GetVoucherTracking_StationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
