<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherTracking_By_ItemID StructType
 * @subpackage Structs
 */
class GetVoucherTracking_By_ItemID extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Credential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetVoucherTracking_By_ItemID
     * @uses GetVoucherTracking_By_ItemID::setItemID()
     * @uses GetVoucherTracking_By_ItemID::setLanguage()
     * @uses GetVoucherTracking_By_ItemID::setCredential()
     * @param string $itemID
     * @param string $language
     * @param \StructType\ClsCredential $credential
     */
    public function __construct($itemID = null, $language = null, \StructType\ClsCredential $credential = null)
    {
        $this
            ->setItemID($itemID)
            ->setLanguage($language)
            ->setCredential($credential);
    }
    /**
     * Get ItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID()
    {
        return isset($this->ItemID) ? $this->ItemID : null;
    }
    /**
     * Set ItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID
     * @return \StructType\GetVoucherTracking_By_ItemID
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        if (is_null($itemID) || (is_array($itemID) && empty($itemID))) {
            unset($this->ItemID);
        } else {
            $this->ItemID = $itemID;
        }
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GetVoucherTracking_By_ItemID
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClsCredential $credential
     * @return \StructType\GetVoucherTracking_By_ItemID
     */
    public function setCredential(\StructType\ClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVoucherTracking_By_ItemID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
