<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherTracking StructType
 * @subpackage Structs
 */
class GetVoucherTracking extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The Credential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetVoucherTracking
     * @uses GetVoucherTracking::setShipmentNumber()
     * @uses GetVoucherTracking::setCredential()
     * @param float $shipmentNumber
     * @param \StructType\ClsCredential $credential
     */
    public function __construct($shipmentNumber = null, \StructType\ClsCredential $credential = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setCredential($credential);
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \StructType\GetVoucherTracking
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClsCredential $credential
     * @return \StructType\GetVoucherTracking
     */
    public function setCredential(\StructType\ClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVoucherTracking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
