<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherPOD StructType
 * @subpackage Structs
 */
class GetVoucherPOD extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The ClsCredential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsCredential
     */
    public $ClsCredential;
    /**
     * Constructor method for GetVoucherPOD
     * @uses GetVoucherPOD::setShipmentNumber()
     * @uses GetVoucherPOD::setClsCredential()
     * @param float $shipmentNumber
     * @param \StructType\ClsCredential $clsCredential
     */
    public function __construct($shipmentNumber = null, \StructType\ClsCredential $clsCredential = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setClsCredential($clsCredential);
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \StructType\GetVoucherPOD
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get ClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsCredential|null
     */
    public function getClsCredential()
    {
        return isset($this->ClsCredential) ? $this->ClsCredential : null;
    }
    /**
     * Set ClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClsCredential $clsCredential
     * @return \StructType\GetVoucherPOD
     */
    public function setClsCredential(\StructType\ClsCredential $clsCredential = null)
    {
        if (is_null($clsCredential) || (is_array($clsCredential) && empty($clsCredential))) {
            unset($this->ClsCredential);
        } else {
            $this->ClsCredential = $clsCredential;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVoucherPOD
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
