<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherMargins StructType
 * @subpackage Structs
 */
class GetVoucherMargins extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The Credential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsCredential
     */
    public $Credential;
    /**
     * The iMargin_Left
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iMargin_Left;
    /**
     * The iMargin_Top
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iMargin_Top;
    /**
     * Constructor method for GetVoucherMargins
     * @uses GetVoucherMargins::setShipmentNumber()
     * @uses GetVoucherMargins::setCredential()
     * @uses GetVoucherMargins::setIMargin_Left()
     * @uses GetVoucherMargins::setIMargin_Top()
     * @param float $shipmentNumber
     * @param \StructType\ClsCredential $credential
     * @param int $iMargin_Left
     * @param int $iMargin_Top
     */
    public function __construct($shipmentNumber = null, \StructType\ClsCredential $credential = null, $iMargin_Left = null, $iMargin_Top = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setCredential($credential)
            ->setIMargin_Left($iMargin_Left)
            ->setIMargin_Top($iMargin_Top);
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \StructType\GetVoucherMargins
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClsCredential $credential
     * @return \StructType\GetVoucherMargins
     */
    public function setCredential(\StructType\ClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
    /**
     * Get iMargin_Left value
     * @return int|null
     */
    public function getIMargin_Left()
    {
        return $this->iMargin_Left;
    }
    /**
     * Set iMargin_Left value
     * @param int $iMargin_Left
     * @return \StructType\GetVoucherMargins
     */
    public function setIMargin_Left($iMargin_Left = null)
    {
        // validation for constraint: int
        if (!is_null($iMargin_Left) && !(is_int($iMargin_Left) || ctype_digit($iMargin_Left))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iMargin_Left, true), gettype($iMargin_Left)), __LINE__);
        }
        $this->iMargin_Left = $iMargin_Left;
        return $this;
    }
    /**
     * Get iMargin_Top value
     * @return int|null
     */
    public function getIMargin_Top()
    {
        return $this->iMargin_Top;
    }
    /**
     * Set iMargin_Top value
     * @param int $iMargin_Top
     * @return \StructType\GetVoucherMargins
     */
    public function setIMargin_Top($iMargin_Top = null)
    {
        // validation for constraint: int
        if (!is_null($iMargin_Top) && !(is_int($iMargin_Top) || ctype_digit($iMargin_Top))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iMargin_Top, true), gettype($iMargin_Top)), __LINE__);
        }
        $this->iMargin_Top = $iMargin_Top;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVoucherMargins
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
