<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClsVoucherTracking StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ClsVoucherTracking
 * @subpackage Structs
 */
class ClsVoucherTracking extends AbstractStructBase
{
    /**
     * The DeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryNotes;
    /**
     * The DeliveryStation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryStation;
    /**
     * The DeliveryTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryTime;
    /**
     * The MasterShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MasterShipmentNumber;
    /**
     * The NonDeliveryReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NonDeliveryReason;
    /**
     * The ReceivedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceivedBy;
    /**
     * The ReturnShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ReturnShipmentNumber;
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The VoucherCheckpoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfClsVoucherCheckpoint
     */
    public $VoucherCheckpoints;
    /**
     * Constructor method for ClsVoucherTracking
     * @uses ClsVoucherTracking::setDeliveryDate()
     * @uses ClsVoucherTracking::setDeliveryNotes()
     * @uses ClsVoucherTracking::setDeliveryStation()
     * @uses ClsVoucherTracking::setDeliveryTime()
     * @uses ClsVoucherTracking::setMasterShipmentNumber()
     * @uses ClsVoucherTracking::setNonDeliveryReason()
     * @uses ClsVoucherTracking::setReceivedBy()
     * @uses ClsVoucherTracking::setReturnShipmentNumber()
     * @uses ClsVoucherTracking::setShipmentNumber()
     * @uses ClsVoucherTracking::setVoucherCheckpoints()
     * @param string $deliveryDate
     * @param string $deliveryNotes
     * @param string $deliveryStation
     * @param string $deliveryTime
     * @param float $masterShipmentNumber
     * @param string $nonDeliveryReason
     * @param string $receivedBy
     * @param float $returnShipmentNumber
     * @param float $shipmentNumber
     * @param \ArrayType\ArrayOfClsVoucherCheckpoint $voucherCheckpoints
     */
    public function __construct($deliveryDate = null, $deliveryNotes = null, $deliveryStation = null, $deliveryTime = null, $masterShipmentNumber = null, $nonDeliveryReason = null, $receivedBy = null, $returnShipmentNumber = null, $shipmentNumber = null, \ArrayType\ArrayOfClsVoucherCheckpoint $voucherCheckpoints = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryNotes($deliveryNotes)
            ->setDeliveryStation($deliveryStation)
            ->setDeliveryTime($deliveryTime)
            ->setMasterShipmentNumber($masterShipmentNumber)
            ->setNonDeliveryReason($nonDeliveryReason)
            ->setReceivedBy($receivedBy)
            ->setReturnShipmentNumber($returnShipmentNumber)
            ->setShipmentNumber($shipmentNumber)
            ->setVoucherCheckpoints($voucherCheckpoints);
    }
    /**
     * Get DeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->DeliveryDate) ? $this->DeliveryDate : null;
    }
    /**
     * Set DeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \StructType\ClsVoucherTracking
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->DeliveryDate);
        } else {
            $this->DeliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get DeliveryNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryNotes()
    {
        return isset($this->DeliveryNotes) ? $this->DeliveryNotes : null;
    }
    /**
     * Set DeliveryNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryNotes
     * @return \StructType\ClsVoucherTracking
     */
    public function setDeliveryNotes($deliveryNotes = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNotes) && !is_string($deliveryNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNotes, true), gettype($deliveryNotes)), __LINE__);
        }
        if (is_null($deliveryNotes) || (is_array($deliveryNotes) && empty($deliveryNotes))) {
            unset($this->DeliveryNotes);
        } else {
            $this->DeliveryNotes = $deliveryNotes;
        }
        return $this;
    }
    /**
     * Get DeliveryStation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryStation()
    {
        return isset($this->DeliveryStation) ? $this->DeliveryStation : null;
    }
    /**
     * Set DeliveryStation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryStation
     * @return \StructType\ClsVoucherTracking
     */
    public function setDeliveryStation($deliveryStation = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStation) && !is_string($deliveryStation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStation, true), gettype($deliveryStation)), __LINE__);
        }
        if (is_null($deliveryStation) || (is_array($deliveryStation) && empty($deliveryStation))) {
            unset($this->DeliveryStation);
        } else {
            $this->DeliveryStation = $deliveryStation;
        }
        return $this;
    }
    /**
     * Get DeliveryTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return isset($this->DeliveryTime) ? $this->DeliveryTime : null;
    }
    /**
     * Set DeliveryTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryTime
     * @return \StructType\ClsVoucherTracking
     */
    public function setDeliveryTime($deliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTime) && !is_string($deliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTime, true), gettype($deliveryTime)), __LINE__);
        }
        if (is_null($deliveryTime) || (is_array($deliveryTime) && empty($deliveryTime))) {
            unset($this->DeliveryTime);
        } else {
            $this->DeliveryTime = $deliveryTime;
        }
        return $this;
    }
    /**
     * Get MasterShipmentNumber value
     * @return float|null
     */
    public function getMasterShipmentNumber()
    {
        return $this->MasterShipmentNumber;
    }
    /**
     * Set MasterShipmentNumber value
     * @param float $masterShipmentNumber
     * @return \StructType\ClsVoucherTracking
     */
    public function setMasterShipmentNumber($masterShipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($masterShipmentNumber) && !(is_float($masterShipmentNumber) || is_numeric($masterShipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($masterShipmentNumber, true), gettype($masterShipmentNumber)), __LINE__);
        }
        $this->MasterShipmentNumber = $masterShipmentNumber;
        return $this;
    }
    /**
     * Get NonDeliveryReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNonDeliveryReason()
    {
        return isset($this->NonDeliveryReason) ? $this->NonDeliveryReason : null;
    }
    /**
     * Set NonDeliveryReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nonDeliveryReason
     * @return \StructType\ClsVoucherTracking
     */
    public function setNonDeliveryReason($nonDeliveryReason = null)
    {
        // validation for constraint: string
        if (!is_null($nonDeliveryReason) && !is_string($nonDeliveryReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonDeliveryReason, true), gettype($nonDeliveryReason)), __LINE__);
        }
        if (is_null($nonDeliveryReason) || (is_array($nonDeliveryReason) && empty($nonDeliveryReason))) {
            unset($this->NonDeliveryReason);
        } else {
            $this->NonDeliveryReason = $nonDeliveryReason;
        }
        return $this;
    }
    /**
     * Get ReceivedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceivedBy()
    {
        return isset($this->ReceivedBy) ? $this->ReceivedBy : null;
    }
    /**
     * Set ReceivedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receivedBy
     * @return \StructType\ClsVoucherTracking
     */
    public function setReceivedBy($receivedBy = null)
    {
        // validation for constraint: string
        if (!is_null($receivedBy) && !is_string($receivedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedBy, true), gettype($receivedBy)), __LINE__);
        }
        if (is_null($receivedBy) || (is_array($receivedBy) && empty($receivedBy))) {
            unset($this->ReceivedBy);
        } else {
            $this->ReceivedBy = $receivedBy;
        }
        return $this;
    }
    /**
     * Get ReturnShipmentNumber value
     * @return float|null
     */
    public function getReturnShipmentNumber()
    {
        return $this->ReturnShipmentNumber;
    }
    /**
     * Set ReturnShipmentNumber value
     * @param float $returnShipmentNumber
     * @return \StructType\ClsVoucherTracking
     */
    public function setReturnShipmentNumber($returnShipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($returnShipmentNumber) && !(is_float($returnShipmentNumber) || is_numeric($returnShipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnShipmentNumber, true), gettype($returnShipmentNumber)), __LINE__);
        }
        $this->ReturnShipmentNumber = $returnShipmentNumber;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \StructType\ClsVoucherTracking
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get VoucherCheckpoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfClsVoucherCheckpoint|null
     */
    public function getVoucherCheckpoints()
    {
        return isset($this->VoucherCheckpoints) ? $this->VoucherCheckpoints : null;
    }
    /**
     * Set VoucherCheckpoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfClsVoucherCheckpoint $voucherCheckpoints
     * @return \StructType\ClsVoucherTracking
     */
    public function setVoucherCheckpoints(\ArrayType\ArrayOfClsVoucherCheckpoint $voucherCheckpoints = null)
    {
        if (is_null($voucherCheckpoints) || (is_array($voucherCheckpoints) && empty($voucherCheckpoints))) {
            unset($this->VoucherCheckpoints);
        } else {
            $this->VoucherCheckpoints = $voucherCheckpoints;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsVoucherTracking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
