<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClsCancelVoucherResp StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ClsCancelVoucherResp
 * @subpackage Structs
 */
class ClsCancelVoucherResp extends AbstractStructBase
{
    /**
     * The Canceled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Canceled;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Result;
    /**
     * Constructor method for ClsCancelVoucherResp
     * @uses ClsCancelVoucherResp::setCanceled()
     * @uses ClsCancelVoucherResp::setMessage()
     * @uses ClsCancelVoucherResp::setResult()
     * @param bool $canceled
     * @param string $message
     * @param bool $result
     */
    public function __construct($canceled = null, $message = null, $result = null)
    {
        $this
            ->setCanceled($canceled)
            ->setMessage($message)
            ->setResult($result);
    }
    /**
     * Get Canceled value
     * @return bool|null
     */
    public function getCanceled()
    {
        return $this->Canceled;
    }
    /**
     * Set Canceled value
     * @param bool $canceled
     * @return \StructType\ClsCancelVoucherResp
     */
    public function setCanceled($canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($canceled) && !is_bool($canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canceled, true), gettype($canceled)), __LINE__);
        }
        $this->Canceled = $canceled;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\ClsCancelVoucherResp
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return \StructType\ClsCancelVoucherResp
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsCancelVoucherResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
