<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://eurocumulus.futurefactory-software.com/EventManagement-CRM-Service-wsdl.xml',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://eurocumulus.futurefactory-software.com/EventManagement-CRM-Service-wsdl.xml',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \ServiceType\Hello($options);
/**
 * Sample call for HelloWorld operation/method
 */
if ($hello->HelloWorld(new \StructType\HelloWorld()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getProduct operation/method
 */
if ($get->getProduct(new \StructType\GetProduct()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAuftrag operation/method
 */
if ($get->getAuftrag(new \StructType\GetAuftrag()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAuftragBySalesorderDetailId operation/method
 */
if ($get->getAuftragBySalesorderDetailId(new \StructType\GetAuftragBySalesorderDetailId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAuftragByDate operation/method
 */
if ($get->getAuftragByDate(new \StructType\GetAuftragByDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactDatas operation/method
 */
if ($get->getContactDatas(new \StructType\GetContactDatas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactDatasByName operation/method
 */
if ($get->getContactDatasByName(new \StructType\GetContactDatasByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactDatasByFirsAndLastName operation/method
 */
if ($get->getContactDatasByFirsAndLastName(new \StructType\GetContactDatasByFirsAndLastName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactDataByUid operation/method
 */
if ($get->getContactDataByUid(new \StructType\GetContactDataByUid()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductByName operation/method
 */
if ($get->getProductByName(new \StructType\GetProductByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductById operation/method
 */
if ($get->getProductById(new \StructType\GetProductById()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductIdByAuftragId operation/method
 */
if ($get->getProductIdByAuftragId(new \StructType\GetProductIdByAuftragId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for setEventnrToOrderline operation/method
 */
if ($set->setEventnrToOrderline(new \StructType\SetEventnrToOrderline()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteEvenetnrFromOrderline operation/method
 */
if ($delete->deleteEvenetnrFromOrderline(new \StructType\DeleteEvenetnrFromOrderline()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
