<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getProductIdByAuftragId StructType
 * @subpackage Structs
 */
class GetProductIdByAuftragId extends AbstractStructBase
{
    /**
     * The soId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $soId;
    /**
     * The ou
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ou;
    /**
     * The ptyp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ptyp;
    /**
     * Constructor method for getProductIdByAuftragId
     * @uses GetProductIdByAuftragId::setSoId()
     * @uses GetProductIdByAuftragId::setOu()
     * @uses GetProductIdByAuftragId::setPtyp()
     * @param string $soId
     * @param int $ou
     * @param string $ptyp
     */
    public function __construct($soId = null, $ou = null, $ptyp = null)
    {
        $this
            ->setSoId($soId)
            ->setOu($ou)
            ->setPtyp($ptyp);
    }
    /**
     * Get soId value
     * @return string
     */
    public function getSoId()
    {
        return $this->soId;
    }
    /**
     * Set soId value
     * @param string $soId
     * @return \StructType\GetProductIdByAuftragId
     */
    public function setSoId($soId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($soId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $soId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($soId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($soId) && !is_string($soId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($soId)), __LINE__);
        }
        $this->soId = $soId;
        return $this;
    }
    /**
     * Get ou value
     * @return int
     */
    public function getOu()
    {
        return $this->ou;
    }
    /**
     * Set ou value
     * @param int $ou
     * @return \StructType\GetProductIdByAuftragId
     */
    public function setOu($ou = null)
    {
        // validation for constraint: int
        if (!is_null($ou) && !is_numeric($ou)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ou)), __LINE__);
        }
        $this->ou = $ou;
        return $this;
    }
    /**
     * Get ptyp value
     * @return string|null
     */
    public function getPtyp()
    {
        return $this->ptyp;
    }
    /**
     * Set ptyp value
     * @param string $ptyp
     * @return \StructType\GetProductIdByAuftragId
     */
    public function setPtyp($ptyp = null)
    {
        // validation for constraint: string
        if (!is_null($ptyp) && !is_string($ptyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ptyp)), __LINE__);
        }
        $this->ptyp = $ptyp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductIdByAuftragId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
