<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAuftragBySalesorderDetailId StructType
 * @subpackage Structs
 */
class GetAuftragBySalesorderDetailId extends AbstractStructBase
{
    /**
     * The sodetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $sodetId;
    /**
     * Constructor method for getAuftragBySalesorderDetailId
     * @uses GetAuftragBySalesorderDetailId::setSodetId()
     * @param string $sodetId
     */
    public function __construct($sodetId = null)
    {
        $this
            ->setSodetId($sodetId);
    }
    /**
     * Get sodetId value
     * @return string
     */
    public function getSodetId()
    {
        return $this->sodetId;
    }
    /**
     * Set sodetId value
     * @param string $sodetId
     * @return \StructType\GetAuftragBySalesorderDetailId
     */
    public function setSodetId($sodetId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sodetId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $sodetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($sodetId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sodetId) && !is_string($sodetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sodetId)), __LINE__);
        }
        $this->sodetId = $sodetId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAuftragBySalesorderDetailId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
