<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProduct $parameters
     * @return \StructType\GetProductResponse|bool
     */
    public function getProduct(\StructType\GetProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAuftrag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAuftrag $parameters
     * @return \StructType\GetAuftragResponse|bool
     */
    public function getAuftrag(\StructType\GetAuftrag $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAuftrag($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAuftragBySalesorderDetailId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAuftragBySalesorderDetailId $parameters
     * @return \StructType\GetAuftragBySalesorderDetailIdResponse|bool
     */
    public function getAuftragBySalesorderDetailId(\StructType\GetAuftragBySalesorderDetailId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAuftragBySalesorderDetailId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAuftragByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAuftragByDate $parameters
     * @return \StructType\GetAuftragByDateResponse|bool
     */
    public function getAuftragByDate(\StructType\GetAuftragByDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAuftragByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactDatas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactDatas $parameters
     * @return \StructType\GetContactDatasResponse|bool
     */
    public function getContactDatas(\StructType\GetContactDatas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getContactDatas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactDatasByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactDatasByName $parameters
     * @return \StructType\GetContactDatasByNameResponse|bool
     */
    public function getContactDatasByName(\StructType\GetContactDatasByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getContactDatasByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactDatasByFirsAndLastName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactDatasByFirsAndLastName $parameters
     * @return \StructType\GetContactDatasByFirsAndLastNameResponse|bool
     */
    public function getContactDatasByFirsAndLastName(\StructType\GetContactDatasByFirsAndLastName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getContactDatasByFirsAndLastName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactDataByUid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactDataByUid $parameters
     * @return \StructType\GetContactDataByUidResponse|bool
     */
    public function getContactDataByUid(\StructType\GetContactDataByUid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getContactDataByUid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductByName $parameters
     * @return \StructType\GetProductByNameResponse|bool
     */
    public function getProductByName(\StructType\GetProductByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductById $parameters
     * @return \StructType\GetProductByIdResponse|bool
     */
    public function getProductById(\StructType\GetProductById $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductIdByAuftragId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductIdByAuftragId $parameters
     * @return \StructType\GetProductIdByAuftragIdResponse|bool
     */
    public function getProductIdByAuftragId(\StructType\GetProductIdByAuftragId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductIdByAuftragId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAuftragByDateResponse|\StructType\GetAuftragBySalesorderDetailIdResponse|\StructType\GetAuftragResponse|\StructType\GetContactDataByUidResponse|\StructType\GetContactDatasByFirsAndLastNameResponse|\StructType\GetContactDatasByNameResponse|\StructType\GetContactDatasResponse|\StructType\GetProductByIdResponse|\StructType\GetProductByNameResponse|\StructType\GetProductIdByAuftragIdResponse|\StructType\GetProductResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
