<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://apac.copy-webservices.travelport.com/B2BGateway/service/XMLSelect?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://apac.copy-webservices.travelport.com/B2BGateway/service/XMLSelect?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
/**
 * Sample call for SubmitXml operation/method
 */
if ($submit->SubmitXml(new \StructType\SubmitXml()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitXmlOnSession operation/method
 */
if ($submit->SubmitXmlOnSession(new \StructType\SubmitXmlOnSession()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitTerminalTransaction operation/method
 */
if ($submit->SubmitTerminalTransaction(new \StructType\SubmitTerminalTransaction()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitCruiseTransaction operation/method
 */
if ($submit->SubmitCruiseTransaction(new \StructType\SubmitCruiseTransaction()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Multi ServiceType
 */
$multi = new \ServiceType\Multi($options);
/**
 * Sample call for MultiSubmitXml operation/method
 */
if ($multi->MultiSubmitXml(new \StructType\MultiSubmitXml()) !== false) {
    print_r($multi->getResult());
} else {
    print_r($multi->getLastError());
}
/**
 * Samples for Begin ServiceType
 */
$begin = new \ServiceType\Begin($options);
/**
 * Sample call for BeginSession operation/method
 */
if ($begin->BeginSession(new \StructType\BeginSession()) !== false) {
    print_r($begin->getResult());
} else {
    print_r($begin->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ServiceType\End($options);
/**
 * Sample call for EndSession operation/method
 */
if ($end->EndSession(new \StructType\EndSession()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetIdentityInfo operation/method
 */
if ($get->GetIdentityInfo(new \StructType\GetIdentityInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
