<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitXml StructType
 * @subpackage Structs
 */
class SubmitXml extends AbstractStructBase
{
    /**
     * The Profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Profile;
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Request
     */
    public $Request;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $Filter;
    /**
     * Constructor method for SubmitXml
     * @uses SubmitXml::setProfile()
     * @uses SubmitXml::setRequest()
     * @uses SubmitXml::setFilter()
     * @param string $profile
     * @param \StructType\Request $request
     * @param \StructType\Filter $filter
     */
    public function __construct($profile = null, \StructType\Request $request = null, \StructType\Filter $filter = null)
    {
        $this
            ->setProfile($profile)
            ->setRequest($request)
            ->setFilter($filter);
    }
    /**
     * Get Profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @param string $profile
     * @return \StructType\SubmitXml
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profile, true), gettype($profile)), __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Get Request value
     * @return \StructType\Request|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\Request $request
     * @return \StructType\SubmitXml
     */
    public function setRequest(\StructType\Request $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get Filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param \StructType\Filter $filter
     * @return \StructType\SubmitXml
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitXml
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
