<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SubmitXml
     * Meta informations extracted from the WSDL
     * - documentation: Submits an XML request in a sessionless environment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitXml $parameters
     * @return \StructType\SubmitXmlResponse|bool
     */
    public function SubmitXml(\StructType\SubmitXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitXmlOnSession
     * Meta informations extracted from the WSDL
     * - documentation: Submits an XML Request on the specified session.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitXmlOnSession $parameters
     * @return \StructType\SubmitXmlOnSessionResponse|bool
     */
    public function SubmitXmlOnSession(\StructType\SubmitXmlOnSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitXmlOnSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitTerminalTransaction
     * Meta informations extracted from the WSDL
     * - documentation: Submits a terminal transaction on a session and returns the result.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitTerminalTransaction $parameters
     * @return \StructType\SubmitTerminalTransactionResponse|bool
     */
    public function SubmitTerminalTransaction(\StructType\SubmitTerminalTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitTerminalTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitCruiseTransaction
     * Meta informations extracted from the WSDL
     * - documentation: Allows callers to submit Cruise transactions to the service
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitCruiseTransaction $parameters
     * @return \StructType\SubmitCruiseTransactionResponse|bool
     */
    public function SubmitCruiseTransaction(\StructType\SubmitCruiseTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitCruiseTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SubmitCruiseTransactionResponse|\StructType\SubmitTerminalTransactionResponse|\StructType\SubmitXmlOnSessionResponse|\StructType\SubmitXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
