<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Multi ServiceType
 * @subpackage Services
 */
class Multi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MultiSubmitXml
     * Meta informations extracted from the WSDL
     * - documentation: Allows users to send multiple sessionless Structured Data transactions within a single web service call. The following restrictions apply:<ul><li>It will not respond until all of the transactions respond. This means the caller must
     * wait for the slowest transaction to return before getting results to any of the transactions.</li><li>It can only be used for unrelated transactions. All transactions may (or may not) be sent simultaneously, and there is no particular order expressed
     * nor implied.</li><li>Terminal transactions are not supported.</li><li>Sessioned transactions are not supported.</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MultiSubmitXml $parameters
     * @return \StructType\MultiSubmitXmlResponse|bool
     */
    public function MultiSubmitXml(\StructType\MultiSubmitXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MultiSubmitXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MultiSubmitXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
