<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Begin ServiceType
 * @subpackage Services
 */
class Begin extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BeginSession
     * Meta informations extracted from the WSDL
     * - documentation: Begins an XML Select session.If this method returns a valid (non-empty) session token, the session must be released with EndSession.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BeginSession $parameters
     * @return \StructType\BeginSessionResponse|bool
     */
    public function BeginSession(\StructType\BeginSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BeginSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BeginSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
