<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://secure.lendingqb.com/los/webservice/EDocsService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://secure.lendingqb.com/los/webservice/EDocsService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LendingQB\LendingQBClassMap::get(),
);
/**
 * Samples for Download ServiceType
 */
$download = new \LendingQB\ServiceType\LendingQBDownload($options);
/**
 * Sample call for DownloadEdocsByShippingTemplate operation/method
 */
if ($download->DownloadEdocsByShippingTemplate(new \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplate()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Sample call for DownloadDocumentNonPdfBytesById operation/method
 */
if ($download->DownloadDocumentNonPdfBytesById(new \LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesById()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Sample call for DownloadTextDocumentById operation/method
 */
if ($download->DownloadTextDocumentById(new \LendingQB\StructType\LendingQBDownloadTextDocumentById()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Sample call for DownloadEdocsPdfById operation/method
 */
if ($download->DownloadEdocsPdfById(new \LendingQB\StructType\LendingQBDownloadEdocsPdfById()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \LendingQB\ServiceType\LendingQBList($options);
/**
 * Sample call for ListDocFolders operation/method
 */
if ($list->ListDocFolders(new \LendingQB\StructType\LendingQBListDocFolders()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListDocTypes operation/method
 */
if ($list->ListDocTypes(new \LendingQB\StructType\LendingQBListDocTypes()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListEDocsAuditHistory operation/method
 */
if ($list->ListEDocsAuditHistory(new \LendingQB\StructType\LendingQBListEDocsAuditHistory()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListEDocsByDocIds operation/method
 */
if ($list->ListEDocsByDocIds(new \LendingQB\StructType\LendingQBListEDocsByDocIds()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListEdocsByLoanNumber operation/method
 */
if ($list->ListEdocsByLoanNumber(new \LendingQB\StructType\LendingQBListEdocsByLoanNumber()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListEdocsByReferenceNumber operation/method
 */
if ($list->ListEdocsByReferenceNumber(new \LendingQB\StructType\LendingQBListEdocsByReferenceNumber()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListModifiedEDocsByAppCode operation/method
 */
if ($list->ListModifiedEDocsByAppCode(new \LendingQB\StructType\LendingQBListModifiedEDocsByAppCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \LendingQB\ServiceType\LendingQBUpdate($options);
/**
 * Sample call for UpdateEdocs operation/method
 */
if ($update->UpdateEdocs(new \LendingQB\StructType\LendingQBUpdateEdocs()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \LendingQB\ServiceType\LendingQBDelete($options);
/**
 * Sample call for DeleteEdocs operation/method
 */
if ($delete->DeleteEdocs(new \LendingQB\StructType\LendingQBDeleteEdocs()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \LendingQB\ServiceType\LendingQBUpload($options);
/**
 * Sample call for UploadDocumentContent operation/method
 */
if ($upload->UploadDocumentContent(new \LendingQB\StructType\LendingQBUploadDocumentContent()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocument operation/method
 */
if ($upload->UploadPDFDocument(new \LendingQB\StructType\LendingQBUploadPDFDocument()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentAsService operation/method
 */
if ($upload->UploadPDFDocumentAsService(new \LendingQB\StructType\LendingQBUploadPDFDocumentAsService()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentByReferenceNumberAsService operation/method
 */
if ($upload->UploadPDFDocumentByReferenceNumberAsService(new \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentToApp operation/method
 */
if ($upload->UploadPDFDocumentToApp(new \LendingQB\StructType\LendingQBUploadPDFDocumentToApp()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentToAppAsService operation/method
 */
if ($upload->UploadPDFDocumentToAppAsService(new \LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsService()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFtoDocumentCapture operation/method
 */
if ($upload->UploadPDFtoDocumentCapture(new \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
