<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadPDFtoDocumentCapture StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadPDFtoDocumentCapture extends AbstractStructBase
{
    /**
     * The applicationId
     * Meta informations extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $applicationId;
    /**
     * The authTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanName;
    /**
     * The pdfContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pdfContent;
    /**
     * The captureUsername
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $captureUsername;
    /**
     * The capturePassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $capturePassword;
    /**
     * Constructor method for UploadPDFtoDocumentCapture
     * @uses LendingQBUploadPDFtoDocumentCapture::setApplicationId()
     * @uses LendingQBUploadPDFtoDocumentCapture::setAuthTicket()
     * @uses LendingQBUploadPDFtoDocumentCapture::setLoanName()
     * @uses LendingQBUploadPDFtoDocumentCapture::setPdfContent()
     * @uses LendingQBUploadPDFtoDocumentCapture::setCaptureUsername()
     * @uses LendingQBUploadPDFtoDocumentCapture::setCapturePassword()
     * @param string $applicationId
     * @param string $authTicket
     * @param string $loanName
     * @param string $pdfContent
     * @param string $captureUsername
     * @param string $capturePassword
     */
    public function __construct($applicationId = null, $authTicket = null, $loanName = null, $pdfContent = null, $captureUsername = null, $capturePassword = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setAuthTicket($authTicket)
            ->setLoanName($loanName)
            ->setPdfContent($pdfContent)
            ->setCaptureUsername($captureUsername)
            ->setCapturePassword($capturePassword);
    }
    /**
     * Get applicationId value
     * @return string
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($applicationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($applicationId, true)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanName value
     * @return string|null
     */
    public function getLoanName()
    {
        return $this->loanName;
    }
    /**
     * Set loanName value
     * @param string $loanName
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public function setLoanName($loanName = null)
    {
        // validation for constraint: string
        if (!is_null($loanName) && !is_string($loanName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanName, true), gettype($loanName)), __LINE__);
        }
        $this->loanName = $loanName;
        return $this;
    }
    /**
     * Get pdfContent value
     * @return string|null
     */
    public function getPdfContent()
    {
        return $this->pdfContent;
    }
    /**
     * Set pdfContent value
     * @param string $pdfContent
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public function setPdfContent($pdfContent = null)
    {
        // validation for constraint: string
        if (!is_null($pdfContent) && !is_string($pdfContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfContent, true), gettype($pdfContent)), __LINE__);
        }
        $this->pdfContent = $pdfContent;
        return $this;
    }
    /**
     * Get captureUsername value
     * @return string|null
     */
    public function getCaptureUsername()
    {
        return $this->captureUsername;
    }
    /**
     * Set captureUsername value
     * @param string $captureUsername
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public function setCaptureUsername($captureUsername = null)
    {
        // validation for constraint: string
        if (!is_null($captureUsername) && !is_string($captureUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($captureUsername, true), gettype($captureUsername)), __LINE__);
        }
        $this->captureUsername = $captureUsername;
        return $this;
    }
    /**
     * Get capturePassword value
     * @return string|null
     */
    public function getCapturePassword()
    {
        return $this->capturePassword;
    }
    /**
     * Set capturePassword value
     * @param string $capturePassword
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public function setCapturePassword($capturePassword = null)
    {
        // validation for constraint: string
        if (!is_null($capturePassword) && !is_string($capturePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($capturePassword, true), gettype($capturePassword)), __LINE__);
        }
        $this->capturePassword = $capturePassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
