<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadPDFDocumentToApp StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadPDFDocumentToApp extends AbstractStructBase
{
    /**
     * The aAppId
     * Meta informations extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $aAppId;
    /**
     * The sTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sLNm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The documentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentType;
    /**
     * The notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * The sDataContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sDataContent;
    /**
     * Constructor method for UploadPDFDocumentToApp
     * @uses LendingQBUploadPDFDocumentToApp::setAAppId()
     * @uses LendingQBUploadPDFDocumentToApp::setSTicket()
     * @uses LendingQBUploadPDFDocumentToApp::setSLNm()
     * @uses LendingQBUploadPDFDocumentToApp::setDocumentType()
     * @uses LendingQBUploadPDFDocumentToApp::setNotes()
     * @uses LendingQBUploadPDFDocumentToApp::setSDataContent()
     * @param string $aAppId
     * @param string $sTicket
     * @param string $sLNm
     * @param string $documentType
     * @param string $notes
     * @param string $sDataContent
     */
    public function __construct($aAppId = null, $sTicket = null, $sLNm = null, $documentType = null, $notes = null, $sDataContent = null)
    {
        $this
            ->setAAppId($aAppId)
            ->setSTicket($sTicket)
            ->setSLNm($sLNm)
            ->setDocumentType($documentType)
            ->setNotes($notes)
            ->setSDataContent($sDataContent);
    }
    /**
     * Get aAppId value
     * @return string
     */
    public function getAAppId()
    {
        return $this->aAppId;
    }
    /**
     * Set aAppId value
     * @param string $aAppId
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public function setAAppId($aAppId = null)
    {
        // validation for constraint: string
        if (!is_null($aAppId) && !is_string($aAppId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aAppId, true), gettype($aAppId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($aAppId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $aAppId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($aAppId, true)), __LINE__);
        }
        $this->aAppId = $aAppId;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTicket, true), gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLNm, true), gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param string $documentType
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get sDataContent value
     * @return string|null
     */
    public function getSDataContent()
    {
        return $this->sDataContent;
    }
    /**
     * Set sDataContent value
     * @param string $sDataContent
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public function setSDataContent($sDataContent = null)
    {
        // validation for constraint: string
        if (!is_null($sDataContent) && !is_string($sDataContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDataContent, true), gettype($sDataContent)), __LINE__);
        }
        $this->sDataContent = $sDataContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToApp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
