<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEdocs StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUpdateEdocs extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The edocLoXml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $edocLoXml;
    /**
     * Constructor method for UpdateEdocs
     * @uses LendingQBUpdateEdocs::setAuthTicket()
     * @uses LendingQBUpdateEdocs::setEdocLoXml()
     * @param string $authTicket
     * @param string $edocLoXml
     */
    public function __construct($authTicket = null, $edocLoXml = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setEdocLoXml($edocLoXml);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBUpdateEdocs
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get edocLoXml value
     * @return string|null
     */
    public function getEdocLoXml()
    {
        return $this->edocLoXml;
    }
    /**
     * Set edocLoXml value
     * @param string $edocLoXml
     * @return \LendingQB\StructType\LendingQBUpdateEdocs
     */
    public function setEdocLoXml($edocLoXml = null)
    {
        // validation for constraint: string
        if (!is_null($edocLoXml) && !is_string($edocLoXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($edocLoXml, true), gettype($edocLoXml)), __LINE__);
        }
        $this->edocLoXml = $edocLoXml;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBUpdateEdocs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
