<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateEdocs
     * Meta informations extracted from the WSDL
     * - documentation: Update the EDocs metadata of the documents described in the edocLoXml.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUpdateEdocs $parameters
     * @return \LendingQB\StructType\LendingQBUpdateEdocsResponse|bool
     */
    public function UpdateEdocs(\LendingQB\StructType\LendingQBUpdateEdocs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateEdocs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBUpdateEdocsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
