<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadPDFDocumentByReferenceNumberAsService StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadPDFDocumentByReferenceNumberAsService extends AbstractStructBase
{
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $serviceType;
    /**
     * The authTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanRefNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanRefNum;
    /**
     * The documentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentType;
    /**
     * The notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * The dataContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataContent;
    /**
     * Constructor method for UploadPDFDocumentByReferenceNumberAsService
     * @uses LendingQBUploadPDFDocumentByReferenceNumberAsService::setServiceType()
     * @uses LendingQBUploadPDFDocumentByReferenceNumberAsService::setAuthTicket()
     * @uses LendingQBUploadPDFDocumentByReferenceNumberAsService::setLoanRefNum()
     * @uses LendingQBUploadPDFDocumentByReferenceNumberAsService::setDocumentType()
     * @uses LendingQBUploadPDFDocumentByReferenceNumberAsService::setNotes()
     * @uses LendingQBUploadPDFDocumentByReferenceNumberAsService::setDataContent()
     * @param string $serviceType
     * @param string $authTicket
     * @param string $loanRefNum
     * @param string $documentType
     * @param string $notes
     * @param string $dataContent
     */
    public function __construct($serviceType = null, $authTicket = null, $loanRefNum = null, $documentType = null, $notes = null, $dataContent = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setAuthTicket($authTicket)
            ->setLoanRefNum($loanRefNum)
            ->setDocumentType($documentType)
            ->setNotes($notes)
            ->setDataContent($dataContent);
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \LendingQB\EnumType\LendingQBTypeOfService::valueIsValid()
     * @uses \LendingQB\EnumType\LendingQBTypeOfService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\LendingQB\EnumType\LendingQBTypeOfService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LendingQB\EnumType\LendingQBTypeOfService', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \LendingQB\EnumType\LendingQBTypeOfService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanRefNum value
     * @return string|null
     */
    public function getLoanRefNum()
    {
        return $this->loanRefNum;
    }
    /**
     * Set loanRefNum value
     * @param string $loanRefNum
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public function setLoanRefNum($loanRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($loanRefNum) && !is_string($loanRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanRefNum, true), gettype($loanRefNum)), __LINE__);
        }
        $this->loanRefNum = $loanRefNum;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param string $documentType
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get dataContent value
     * @return string|null
     */
    public function getDataContent()
    {
        return $this->dataContent;
    }
    /**
     * Set dataContent value
     * @param string $dataContent
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public function setDataContent($dataContent = null)
    {
        // validation for constraint: string
        if (!is_null($dataContent) && !is_string($dataContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataContent, true), gettype($dataContent)), __LINE__);
        }
        $this->dataContent = $dataContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
