<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocumentContent StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadDocumentContent extends AbstractStructBase
{
    /**
     * The appId
     * Meta informations extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $appId;
    /**
     * The docTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $docTypeId;
    /**
     * The authTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanRefNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanRefNum;
    /**
     * The fileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dataContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataContent;
    /**
     * Constructor method for UploadDocumentContent
     * @uses LendingQBUploadDocumentContent::setAppId()
     * @uses LendingQBUploadDocumentContent::setDocTypeId()
     * @uses LendingQBUploadDocumentContent::setAuthTicket()
     * @uses LendingQBUploadDocumentContent::setLoanRefNum()
     * @uses LendingQBUploadDocumentContent::setFileName()
     * @uses LendingQBUploadDocumentContent::setDescription()
     * @uses LendingQBUploadDocumentContent::setDataContent()
     * @param string $appId
     * @param int $docTypeId
     * @param string $authTicket
     * @param string $loanRefNum
     * @param string $fileName
     * @param string $description
     * @param string $dataContent
     */
    public function __construct($appId = null, $docTypeId = null, $authTicket = null, $loanRefNum = null, $fileName = null, $description = null, $dataContent = null)
    {
        $this
            ->setAppId($appId)
            ->setDocTypeId($docTypeId)
            ->setAuthTicket($authTicket)
            ->setLoanRefNum($loanRefNum)
            ->setFileName($fileName)
            ->setDescription($description)
            ->setDataContent($dataContent);
    }
    /**
     * Get appId value
     * @return string
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param string $appId
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: string
        if (!is_null($appId) && !is_string($appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($appId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($appId, true)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
    /**
     * Get docTypeId value
     * @return int
     */
    public function getDocTypeId()
    {
        return $this->docTypeId;
    }
    /**
     * Set docTypeId value
     * @param int $docTypeId
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setDocTypeId($docTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($docTypeId) && !(is_int($docTypeId) || ctype_digit($docTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docTypeId, true), gettype($docTypeId)), __LINE__);
        }
        $this->docTypeId = $docTypeId;
        return $this;
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanRefNum value
     * @return string|null
     */
    public function getLoanRefNum()
    {
        return $this->loanRefNum;
    }
    /**
     * Set loanRefNum value
     * @param string $loanRefNum
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setLoanRefNum($loanRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($loanRefNum) && !is_string($loanRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanRefNum, true), gettype($loanRefNum)), __LINE__);
        }
        $this->loanRefNum = $loanRefNum;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dataContent value
     * @return string|null
     */
    public function getDataContent()
    {
        return $this->dataContent;
    }
    /**
     * Set dataContent value
     * @param string $dataContent
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public function setDataContent($dataContent = null)
    {
        // validation for constraint: string
        if (!is_null($dataContent) && !is_string($dataContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataContent, true), gettype($dataContent)), __LINE__);
        }
        $this->dataContent = $dataContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBUploadDocumentContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
