<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListEdocsByReferenceNumber StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBListEdocsByReferenceNumber extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanRefNum;
    /**
     * Constructor method for ListEdocsByReferenceNumber
     * @uses LendingQBListEdocsByReferenceNumber::setAuthTicket()
     * @uses LendingQBListEdocsByReferenceNumber::setLoanRefNum()
     * @param string $authTicket
     * @param string $loanRefNum
     */
    public function __construct($authTicket = null, $loanRefNum = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setLoanRefNum($loanRefNum);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBListEdocsByReferenceNumber
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanRefNum value
     * @return string|null
     */
    public function getLoanRefNum()
    {
        return $this->loanRefNum;
    }
    /**
     * Set loanRefNum value
     * @param string $loanRefNum
     * @return \LendingQB\StructType\LendingQBListEdocsByReferenceNumber
     */
    public function setLoanRefNum($loanRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($loanRefNum) && !is_string($loanRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanRefNum, true), gettype($loanRefNum)), __LINE__);
        }
        $this->loanRefNum = $loanRefNum;
        return $this;
    }
}
