<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBList extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListDocFolders
     * Meta information extracted from the WSDL
     * - documentation: This method retrieves a list of EDocs folders the user has access to and their associated roles. [ticket] Ticket returned by AuthService.asmx. Output is a string in LOXML format. The result includes a status attribute [ERROR |
     * COMPLETE]. ERROR responses include an error message. COMPLETE responses include an LOXML list of DocTypes, and the folders with their respective allowed roles.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListDocFolders $parameters
     * @return \LendingQB\StructType\LendingQBListDocFoldersResponse|bool
     */
    public function ListDocFolders(\LendingQB\StructType\LendingQBListDocFolders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListDocFolders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListDocTypes
     * Meta information extracted from the WSDL
     * - documentation: This method retrieves a list of EDocs DocTypes the user has access, as well as Document Folders the user has access to and their associated roles. [ticket] Ticket returned by AuthService.asmx. Output is a string in LOXML format. The
     * result includes a status attribute [ERROR | COMPLETE]. ERROR responses include an error message. COMPLETE responses include an LOXML list of DocTypes, and the folders with their respective allowed roles.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListDocTypes $parameters
     * @return \LendingQB\StructType\LendingQBListDocTypesResponse|bool
     */
    public function ListDocTypes(\LendingQB\StructType\LendingQBListDocTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListDocTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListEDocsAuditHistory
     * Meta information extracted from the WSDL
     * - documentation: MERIDIANLINK MORTGAGE INTERNAL USE ONLY.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListEDocsAuditHistory $parameters
     * @return \LendingQB\StructType\LendingQBListEDocsAuditHistoryResponse|bool
     */
    public function ListEDocsAuditHistory(\LendingQB\StructType\LendingQBListEDocsAuditHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListEDocsAuditHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListEDocsByDocIds
     * Meta information extracted from the WSDL
     * - documentation: MERIDIANLINK MORTGAGE INTERNAL USE ONLY.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListEDocsByDocIds $parameters
     * @return \LendingQB\StructType\LendingQBListEDocsByDocIdsResponse|bool
     */
    public function ListEDocsByDocIds(\LendingQB\StructType\LendingQBListEDocsByDocIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListEDocsByDocIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListEdocsByLoanNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListEdocsByLoanNumber $parameters
     * @return \LendingQB\StructType\LendingQBListEdocsByLoanNumberResponse|bool
     */
    public function ListEdocsByLoanNumber(\LendingQB\StructType\LendingQBListEdocsByLoanNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListEdocsByLoanNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListEdocsByReferenceNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListEdocsByReferenceNumber $parameters
     * @return \LendingQB\StructType\LendingQBListEdocsByReferenceNumberResponse|bool
     */
    public function ListEdocsByReferenceNumber(\LendingQB\StructType\LendingQBListEdocsByReferenceNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListEdocsByReferenceNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListModifiedEDocsByAppCode
     * Meta information extracted from the WSDL
     * - documentation: Returns an XML document containing a list of recently modified EDocs. This method is used if the client wants to poll the LO/PML system on a fixed interval (try to keep this interval big) for recently modified files so that they can
     * be imported into a 3rd-party LOS. Contact support for valid appCode. THIS METHOD ONLY RETURN EDOCS MODIFIED SINCE THE LAST MODIFIED DATE. THE METHOD WILL NOT RETURN DOCUMENTS MODIFIED PASSED 3 MONTHS.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListModifiedEDocsByAppCode $parameters
     * @return \LendingQB\StructType\LendingQBListModifiedEDocsByAppCodeResponse|bool
     */
    public function ListModifiedEDocsByAppCode(\LendingQB\StructType\LendingQBListModifiedEDocsByAppCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListModifiedEDocsByAppCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBListDocFoldersResponse|\LendingQB\StructType\LendingQBListDocTypesResponse|\LendingQB\StructType\LendingQBListEDocsAuditHistoryResponse|\LendingQB\StructType\LendingQBListEDocsByDocIdsResponse|\LendingQB\StructType\LendingQBListEdocsByLoanNumberResponse|\LendingQB\StructType\LendingQBListEdocsByReferenceNumberResponse|\LendingQB\StructType\LendingQBListModifiedEDocsByAppCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
