<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocumentWithOptions StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadDocumentWithOptions extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileName;
    /**
     * The optionsXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsXml;
    /**
     * The dataContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataContent;
    /**
     * Constructor method for UploadDocumentWithOptions
     * @uses LendingQBUploadDocumentWithOptions::setAuthTicket()
     * @uses LendingQBUploadDocumentWithOptions::setFileName()
     * @uses LendingQBUploadDocumentWithOptions::setOptionsXml()
     * @uses LendingQBUploadDocumentWithOptions::setDataContent()
     * @param string $authTicket
     * @param string $fileName
     * @param string $optionsXml
     * @param string $dataContent
     */
    public function __construct($authTicket = null, $fileName = null, $optionsXml = null, $dataContent = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setFileName($fileName)
            ->setOptionsXml($optionsXml)
            ->setDataContent($dataContent);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBUploadDocumentWithOptions
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \LendingQB\StructType\LendingQBUploadDocumentWithOptions
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get optionsXml value
     * @return string|null
     */
    public function getOptionsXml()
    {
        return $this->optionsXml;
    }
    /**
     * Set optionsXml value
     * @param string $optionsXml
     * @return \LendingQB\StructType\LendingQBUploadDocumentWithOptions
     */
    public function setOptionsXml($optionsXml = null)
    {
        // validation for constraint: string
        if (!is_null($optionsXml) && !is_string($optionsXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionsXml, true), gettype($optionsXml)), __LINE__);
        }
        $this->optionsXml = $optionsXml;
        return $this;
    }
    /**
     * Get dataContent value
     * @return string|null
     */
    public function getDataContent()
    {
        return $this->dataContent;
    }
    /**
     * Set dataContent value
     * @param string $dataContent
     * @return \LendingQB\StructType\LendingQBUploadDocumentWithOptions
     */
    public function setDataContent($dataContent = null)
    {
        // validation for constraint: string
        if (!is_null($dataContent) && !is_string($dataContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataContent, true), gettype($dataContent)), __LINE__);
        }
        $this->dataContent = $dataContent;
        return $this;
    }
}
