<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBUpload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadDocumentContent
     * Meta information extracted from the WSDL
     * - documentation: Uploads a document to a loan file. [authTicket] Ticket returned by AuthService.asmx. [loanRefNum] The MeridianLink Mortgage Loan Reference Number. [appId] The application ID to associate the new document with. [fileName] The file
     * name of the uploaded file. File extension will be used to determine what format the file should be understood as. [docTypeId] The document type identifier, which can be retrieved from the ListDocTypes method. [description] Public information related
     * to the PDF document. [dataContent] The byte content of the document. Text files should be UTF-8 encoded before SOAP encoding.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadDocumentContent $parameters
     * @return \LendingQB\StructType\LendingQBUploadDocumentContentResponse|bool
     */
    public function UploadDocumentContent(\LendingQB\StructType\LendingQBUploadDocumentContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadDocumentContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocument
     * Meta information extracted from the WSDL
     * - documentation: Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [documentType] The PDF document type name. [notes] Notes related to the PDF document. [sDataContent] The base 64
     * encoded PDF document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocument $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentResponse|bool
     */
    public function UploadPDFDocument(\LendingQB\StructType\LendingQBUploadPDFDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocumentAsService
     * Meta information extracted from the WSDL
     * - documentation: Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [documentType] The PDF document type name. [notes] Notes related to the PDF document. [sDataContent] The base 64
     * encoded PDF document. [serviceType] The type of service currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentAsService $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentAsServiceResponse|bool
     */
    public function UploadPDFDocumentAsService(\LendingQB\StructType\LendingQBUploadPDFDocumentAsService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentAsService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UploadPDFDocumentByReferenceNumberAsService
     * Meta information extracted from the WSDL
     * - documentation: Add a PDF to a loan file. [authTicket] Ticket returned by AuthService.asmx. [loanRefNum] The LendingQB Loan Reference Number. [documentType] The PDF document type name. [notes] Notes related to the PDF document. [dataContent] The
     * base 64 encoded PDF document. [serviceType] The type of service currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsServiceResponse|bool
     */
    public function UploadPDFDocumentByReferenceNumberAsService(\LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentByReferenceNumberAsService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocumentToApp
     * Meta information extracted from the WSDL
     * - documentation: Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [aAppId] The Application Id to contain the file. [documentType] The PDF document type name. [notes] Notes related to
     * the PDF document. [sDataContent] The base 64 encoded PDF document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentToApp $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToAppResponse|bool
     */
    public function UploadPDFDocumentToApp(\LendingQB\StructType\LendingQBUploadPDFDocumentToApp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentToApp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocumentToAppAsService
     * Meta information extracted from the WSDL
     * - documentation: Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [aAppId] The Application Id to contain the file. [documentType] The PDF document type name. [notes] Notes related to
     * the PDF document. [sDataContent] The base 64 encoded PDF document. [serviceType] The type of service currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsService $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsServiceResponse|bool
     */
    public function UploadPDFDocumentToAppAsService(\LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentToAppAsService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFtoDocumentCapture
     * Meta information extracted from the WSDL
     * - documentation: Uploads a PDF into the document capture system. [authTicket] Ticket returned by AuthService.asmx. [loanName] The MeridianLink Mortgage Loan Name. [applicationId] The ID of the application to associate with the document. [pdfContent]
     * The base 64 encoded PDF document. [captureUsername] Optional. The username for the document capture system. [capturePassword] Optional. The password for the document capture system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFtoDocumentCaptureResponse|bool
     */
    public function UploadPDFtoDocumentCapture(\LendingQB\StructType\LendingQBUploadPDFtoDocumentCapture $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFtoDocumentCapture($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadDocumentWithOptions
     * Meta information extracted from the WSDL
     * - documentation: Uploads a document with specific settings, using LOXML. [sTicket] Ticket returned by AuthServices.asmx. [fileName] Name of the uploaded file. [optionsXml] LoXml with loanid / loan reference number / loan number, doc_type_id /
     * doc_type, and optionally appId, description, internal_description, doc_status, doc_status_description, service_type, and hide_from_pml_users. [dataContent] Byte array representation of the uploaded file.[returns] The result XML, with correct document
     * upload feedback.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadDocumentWithOptions $parameters
     * @return \LendingQB\StructType\LendingQBUploadDocumentWithOptionsResponse|bool
     */
    public function UploadDocumentWithOptions(\LendingQB\StructType\LendingQBUploadDocumentWithOptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadDocumentWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBUploadDocumentContentResponse|\LendingQB\StructType\LendingQBUploadDocumentWithOptionsResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentAsServiceResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentByReferenceNumberAsServiceResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsServiceResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentToAppResponse|\LendingQB\StructType\LendingQBUploadPDFtoDocumentCaptureResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
