<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Download ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBDownload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DownloadEdocsByShippingTemplate
     * Meta information extracted from the WSDL
     * - documentation: This method returns a PDF containing EDocs on the given loan file [sLNm] that are included in the shipping template [sShippingTemplateName]. EDocs with Protected status are included by default. Obsolete/Rejected docs are omitted.
     * Does not preserve electronic signatures.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplate $parameters
     * @return \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplateResponse|bool
     */
    public function DownloadEdocsByShippingTemplate(\LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadEdocsByShippingTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadDocumentNonPdfBytesById
     * Meta information extracted from the WSDL
     * - documentation: Downloads the non-PDF byte content related to the document with the given [docId]. This method will not return PDF EDocs, use DownloadEdocsPdfById() for that instead. Some EDocs (e.g. UCD) may have both PDF and text content.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesById $parameters
     * @return \LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesByIdResponse|bool
     */
    public function DownloadDocumentNonPdfBytesById(\LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadDocumentNonPdfBytesById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadTextDocumentById
     * Meta information extracted from the WSDL
     * - documentation: Downloads the non-PDF text content related to the document with the given [docId]. This method will not return EDocs PDF content, use DownloadEdocsPdfById() for that instead. Some EDocs (e.g. UCD) may have both PDF and non-PDF
     * content.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDownloadTextDocumentById $parameters
     * @return \LendingQB\StructType\LendingQBDownloadTextDocumentByIdResponse|bool
     */
    public function DownloadTextDocumentById(\LendingQB\StructType\LendingQBDownloadTextDocumentById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadTextDocumentById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadEdocsPdfById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDownloadEdocsPdfById $parameters
     * @return \LendingQB\StructType\LendingQBDownloadEdocsPdfByIdResponse|bool
     */
    public function DownloadEdocsPdfById(\LendingQB\StructType\LendingQBDownloadEdocsPdfById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadEdocsPdfById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesByIdResponse|\LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplateResponse|\LendingQB\StructType\LendingQBDownloadEdocsPdfByIdResponse|\LendingQB\StructType\LendingQBDownloadTextDocumentByIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
